package org.xdi.graphmodel.api;

import org.xdi.graphmodel.api.graph.XdiNode;

/**
 * Graph traversing function.
 *
 * @author Yuriy Zabrovarnyy
 * @version 0.9, 09/05/2011
 */
public interface GraphTraversFunction {

    /**
     * Apply function to node.
     *
     * @param p_node handled node
     */
    public void apply(XdiNode p_node);

    /**
     * Returns whether traversing should be terminated or not.
     *
     * @param p_node handled node
     * @return whether traversing should be terminated or not
     */
    public boolean getTerminateCondition(XdiNode p_node);

    /**
     * Returns node on which termination was performed.
     *
     * @return node on which termination was performed
     */
    public XdiNode getTerminateNode();
}
