package org.xdi.graphmodel.api;

import org.xdi.graphmodel.api.graph.XdiNode;
import org.xdi.graphmodel.api.graph.XdiStatement;
import org.xdi.graphmodel.api.xri.Xri;

import java.util.List;
import java.util.Set;

/**
 * Base class to extract different type of information from graph model.
 *
 * @author Yuriy Zabrovarnyy
 * @version 0.9, 3/26/11
 */
public interface GraphExtractor {

    /**
     * Extracts node's xri list from graph model.
     *
     * @param p_graph root node of graph model
     * @return xri set that contains xri of each node within the graph
     */
    Set<Xri> extractXriList(RootNode p_graph);

    /**
     * Extracts xdi statement list from graph model.
     *
     * @param p_xdiNode xdi node of graph model
     * @return xdi statement list from graph
     */
    List<XdiStatement> extractXdiStatementList(XdiNode p_xdiNode);

    /**
     * Returns xdi node by xri from graph (or subgraph).
     *
     * @param p_xdiNode start traversing from this xdi node
     * @param p_nodeXri xri of node to find
     * @return xdi node
     */
    public XdiNode getNodeByXri(XdiNode p_xdiNode, final Xri p_nodeXri);
}
