package org.xdi.graphmodel.api;

import java.io.Serializable;

/**
 * Convenient interface to get string representation of object. Should be used only if simple string
 * transformation is possible. Shouldn't be used for complex types to avoid telescoping programming.
 * <p/>
 * Don't use toString() method to get string representation of object. It must be used for debug purposes only!
 *
 * @author Yuriy Zabrovarnyy
 * @version 0.9, 3/27/11
 * @see org.xdi.graphmodel.api.xri.Xri
 */
public interface AsString extends Serializable {

    /**
     * @return string representation of object.
     */
    public String asString();
}
