/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.graphmodel.xdistatements.core;

import org.xdi.graphmodel.BaseTestCase;
import org.xdi.graphmodel.api.graph.XdiStatement;
import org.xdi.graphmodel.impl.XdiStatementImpl;

public class XdiStatementParserTest
extends BaseTestCase {
    public void testParser() {
        XdiStatementParserTest.assertParser("asdf/asdf/asdf", "asdf", "asdf", "asdf");
        XdiStatementParserTest.assertParser("asdf/$()/asdf", "asdf", "$()", "asdf");
        XdiStatementParserTest.assertParser("asdf/()/asdf", "asdf", "()", "asdf");
        XdiStatementParserTest.assertParser("asdf/()/(asdf)", "asdf", "()", "(asdf)");
        XdiStatementParserTest.assertParser("asdf/()/(as/d/f)", "asdf", "()", "(as/d/f)");
        XdiStatementParserTest.assertParser("fromSegment$do/$add/(=abc/()/xyz)", "fromSegment$do", "$add", "(=abc/()/xyz)");
        XdiStatementParserTest.assertParser("()/$()/(=abc)", "()", "$()", "(=abc)");
        XdiStatementParserTest.assertParser("=abc/+friend/(http://facebook.com)=xyz", "=abc", "+friend", "(http://facebook.com)=xyz");
        XdiStatementParserTest.assertParser("fromSegment$do/$add/(=abc/($)/(=abc+age/$d!))", "fromSegment$do", "$add", "(=abc/($)/(=abc+age/$d!))");
        XdiStatementParserTest.assertParser("sender/$add/(=schwartz/()/($1))", "sender", "$add", "(=schwartz/()/($1))");
        XdiStatementParserTest.assertParser("=schwartz/()/($1)", "=schwartz", "()", "($1)");
        XdiStatementParserTest.assertParser("=schwartz($1)/()/+friends", "=schwartz($1)", "()", "+friends");
    }

    private static void assertParser(String p_xdiStatement, String p_expectedSubject, String p_expectedPredicate, String p_expectedObject) {
        XdiStatement s = XdiStatementImpl.valueOf((String)p_xdiStatement);
        XdiStatementParserTest.assertTrue((s != null && s.getSubject().asString().equals(p_expectedSubject) && s.getPredicate().asString().equals(p_expectedPredicate) && s.getObject().asString().equals(p_expectedObject) ? 1 : 0) != 0);
    }
}

