/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.graphmodel.operation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.xdi.graphmodel.BaseTestCase;
import org.xdi.graphmodel.TUtils;
import org.xdi.graphmodel.TestGraphBuilder;
import org.xdi.graphmodel.api.RootNode;
import org.xdi.graphmodel.api.graph.XdiNode;
import org.xdi.graphmodel.api.graph.XdiStatement;
import org.xdi.graphmodel.api.operation.Operation;
import org.xdi.graphmodel.api.operation.OperationResult;
import org.xdi.graphmodel.common.Utils;
import org.xdi.graphmodel.impl.XdiStatementImpl;

public class DeleteOperationTest
extends BaseTestCase {
    private List<XdiStatement> expectedXdiStatementListForLiteralNodeDeletion() {
        ArrayList<XdiStatement> list = new ArrayList<XdiStatement>();
        list.add(XdiStatementImpl.valueOf((String)"()/()/=abc"));
        list.add(XdiStatementImpl.valueOf((String)"=abc/()/+age"));
        list.add(XdiStatementImpl.valueOf((String)"=abc/+age!/(data:,33)"));
        list.add(XdiStatementImpl.valueOf((String)"=abc+age/()/$v"));
        list.add(XdiStatementImpl.valueOf((String)"=abc+age/$v/=abc+age$v!2"));
        list.add(XdiStatementImpl.valueOf((String)"=abc+age$v/()/!1"));
        list.add(XdiStatementImpl.valueOf((String)"=abc+age$v/()/!2"));
        list.add(XdiStatementImpl.valueOf((String)"=abc+age$v/!2/(=abc/+age!)"));
        list.add(XdiStatementImpl.valueOf((String)"=abc+age$v/!1!/(data:,32)"));
        list.add(XdiStatementImpl.valueOf((String)"=abc+age$v!1/$d!/(data:,2010-09-09T10:11:12Z)"));
        list.add(XdiStatementImpl.valueOf((String)"=abc+age$v!2/$d!/(data:,2010-10-10T11:12:13Z)"));
        return list;
    }

    private List<XdiStatement> expectedXdiStatementListForContextNodeDeletion() {
        ArrayList<XdiStatement> list = new ArrayList<XdiStatement>();
        list.add(XdiStatementImpl.valueOf((String)"()/()/=abc"));
        list.add(XdiStatementImpl.valueOf((String)"=abc/()/+age"));
        list.add(XdiStatementImpl.valueOf((String)"=abc/+age!/(data:,33)"));
        list.add(XdiStatementImpl.valueOf((String)"=abc+age/()/$v"));
        list.add(XdiStatementImpl.valueOf((String)"=abc+age/$v/=abc+age$v!2"));
        list.add(XdiStatementImpl.valueOf((String)"=abc+age/$d!/(data:,2010-10-10T11:12:13Z)"));
        list.add(XdiStatementImpl.valueOf((String)"=abc+age$v/()/!2"));
        list.add(XdiStatementImpl.valueOf((String)"=abc+age$v/!2/(=abc/+age!)"));
        list.add(XdiStatementImpl.valueOf((String)"=abc+age$v/!1!/(data:,32)"));
        list.add(XdiStatementImpl.valueOf((String)"=abc+age$v!2/$d!/(data:,2010-10-10T11:12:13Z)"));
        return list;
    }

    public void testDeleteRelationalArc() {
        RootNode graph = TestGraphBuilder.createSimpleProperties20110404();
        List beforeRemoving = TUtils.EXTRACTOR.extractXdiStatementList((XdiNode)graph);
        Utils.printList((Collection)beforeRemoving);
        String toRemove = "=abc+age/$v/=abc+age$v!2";
        Operation operation = TUtils.OPERATION_FACTORY.create(XdiStatementImpl.valueOf((String)"fromSegment$do/$del/(=abc+age/$v/=abc+age$v!2)"));
        OperationResult result = operation.apply(graph);
        DeleteOperationTest.assertTrue((result != null && result.getSuccessful() ? 1 : 0) != 0);
        List afterRemoving = TUtils.EXTRACTOR.extractXdiStatementList((XdiNode)graph);
        beforeRemoving.removeAll(afterRemoving);
        DeleteOperationTest.assertTrue((boolean)((XdiStatement)beforeRemoving.get(0)).asString().equals("=abc+age/$v/=abc+age$v!2"));
    }

    public void testDeleteLiteralNode() {
        RootNode graph = TestGraphBuilder.createSimpleProperties20110404();
        Operation operation = TUtils.OPERATION_FACTORY.create(XdiStatementImpl.valueOf((String)"fromSegment$do/$del/(=abc+age/$d!)"));
        OperationResult result = operation.apply(graph);
        DeleteOperationTest.assertTrue((result != null && result.getSuccessful() ? 1 : 0) != 0);
        List list = TUtils.EXTRACTOR.extractXdiStatementList((XdiNode)graph);
        list.removeAll(this.expectedXdiStatementListForLiteralNodeDeletion());
        DeleteOperationTest.assertTrue((boolean)list.isEmpty());
    }

    public void testDeleteContextualNode() {
        RootNode graph = TestGraphBuilder.createSimpleProperties20110404();
        Operation operation = TUtils.OPERATION_FACTORY.create(XdiStatementImpl.valueOf((String)"fromSegment$do/$del/=abc+age$v!1"));
        OperationResult result = operation.apply(graph);
        DeleteOperationTest.assertTrue((result != null && result.getSuccessful() ? 1 : 0) != 0);
        List list = TUtils.EXTRACTOR.extractXdiStatementList((XdiNode)graph);
        list.removeAll(this.expectedXdiStatementListForContextNodeDeletion());
        DeleteOperationTest.assertTrue((boolean)list.isEmpty());
    }

    public void testDeleteContextualNodeWithCrossReference() {
        RootNode graph = TestGraphBuilder.createComplexPropertiesGraph20110404();
        Operation operation = TUtils.OPERATION_FACTORY.create(XdiStatementImpl.valueOf((String)"fromSegment$do/$del/=abc+tel$v"));
        OperationResult result = operation.apply(graph);
        DeleteOperationTest.assertTrue((result != null && result.getSuccessful() ? 1 : 0) != 0);
        List list = TUtils.EXTRACTOR.extractXdiStatementList((XdiNode)graph);
        list.removeAll(this.expectedXdiStatementListForContextualNodeWithCrossReference());
        DeleteOperationTest.assertTrue((boolean)list.isEmpty());
    }

    public void testDeleteContextualNodeWithCrossReference_Negative() {
        RootNode graph = TestGraphBuilder.createComplexPropertiesGraph20110404();
        Operation operation = TUtils.OPERATION_FACTORY.create(XdiStatementImpl.valueOf((String)"fromSegment$do/$del/=abc+tel$v3"));
        OperationResult result = operation.apply(graph);
        DeleteOperationTest.assertTrue((result != null && !result.getSuccessful() ? 1 : 0) != 0);
    }

    private List<XdiStatement> expectedXdiStatementListForContextualNodeWithCrossReference() {
        ArrayList<XdiStatement> list = new ArrayList<XdiStatement>();
        list.add(XdiStatementImpl.valueOf((String)"()/()/=abc"));
        list.add(XdiStatementImpl.valueOf((String)"=abc/()/+tel"));
        list.add(XdiStatementImpl.valueOf((String)"=abc+tel/()/!1"));
        list.add(XdiStatementImpl.valueOf((String)"=abc+tel/()/!2"));
        list.add(XdiStatementImpl.valueOf((String)"=abc+tel/*1/!2!"));
        list.add(XdiStatementImpl.valueOf((String)"=abc+tel/*2/!1!"));
        list.add(XdiStatementImpl.valueOf((String)"=abc+tel/+home/!1!"));
        list.add(XdiStatementImpl.valueOf((String)"=abc+tel/+home+fax/!1!"));
        list.add(XdiStatementImpl.valueOf((String)"=abc+tel/+work/!2!"));
        list.add(XdiStatementImpl.valueOf((String)"=abc+tel/$v/=abc+tel$v!2"));
        list.add(XdiStatementImpl.valueOf((String)"=abc+tel/!1!/(data:,+1.206.555.1111)"));
        list.add(XdiStatementImpl.valueOf((String)"=abc+tel/!2!/(data:,+1.206.555.2222)"));
        list.add(XdiStatementImpl.valueOf((String)"=abc+tel!1/$d!/(data:,2010-11-11T11:11:11Z)"));
        list.add(XdiStatementImpl.valueOf((String)"=abc+tel!2/$d!/(data:,2010-12-22T22:22:22Z)"));
        return list;
    }
}

