/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.graphmodel;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;
import org.json.simple.parser.ParseException;
import org.xdi.graphmodel.TUtils;
import org.xdi.graphmodel.api.RootNode;
import org.xdi.graphmodel.api.graph.XdiNode;
import org.xdi.graphmodel.api.graph.XdiStatement;
import org.xdi.graphmodel.impl.XdiStatementImpl;
import org.xdi.graphmodel.usage.JSONConvertor;

public abstract class BaseTestCase
extends TestCase {
    protected final Properties m_properties = new Properties();

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected RootNode createGraph(String p_propertiesKey) {
        return BaseTestCase.createGraph(p_propertiesKey, this.m_properties);
    }

    public static RootNode createGraph(String p_propertiesKey, Properties p_properties) {
        List<XdiStatement> xdiStatementList = BaseTestCase.createXdiStatementList(p_propertiesKey, p_properties);
        if (xdiStatementList != null && !xdiStatementList.isEmpty()) {
            return TUtils.BUILDER.createGraph(xdiStatementList);
        }
        return null;
    }

    public static List<XdiStatement> createXdiStatementList(String p_propertiesKey, Properties p_properties) {
        String value;
        String[] xdiStatements;
        ArrayList<XdiStatement> list = new ArrayList<XdiStatement>();
        if (p_propertiesKey != null && p_properties != null && (xdiStatements = (value = p_properties.getProperty(p_propertiesKey)).split("\n")) != null && xdiStatements.length > 0) {
            for (String statement : xdiStatements) {
                list.add(XdiStatementImpl.valueOf((String)statement));
            }
        }
        return list;
    }

    protected List<XdiStatement> expectedXdiStatementList() {
        return new ArrayList<XdiStatement>();
    }

    protected void testGraphCreationAndExtraction(Class p_class) {
        System.out.println("Test graph creation and extraction " + p_class.getSimpleName() + " ...");
        List<XdiStatement> xdiStatements = this.expectedXdiStatementList();
        RootNode graph = TUtils.BUILDER.createGraph(xdiStatements);
        List extracted = TUtils.EXTRACTOR.extractXdiStatementList((XdiNode)graph);
        extracted.removeAll(xdiStatements);
        BaseTestCase.assertTrue((String)("Unexpected xdi statements: " + extracted), (boolean)extracted.isEmpty());
        System.out.println("--------- Test passed!");
    }

    public void testJson(Class p_class) throws ParseException {
        System.out.println("Test json convertion " + p_class.getSimpleName() + "...");
        List<XdiStatement> expectedList = this.expectedXdiStatementList();
        String json = JSONConvertor.constructJson(expectedList);
        System.out.println("JSON string: " + json);
        List constructedList = JSONConvertor.construct((String)json);
        constructedList.removeAll(expectedList);
        BaseTestCase.assertTrue((String)("JSON Convertor found xdi statements that are not expected: " + constructedList), (boolean)constructedList.isEmpty());
        System.out.println("--------- Test passed!");
    }

    public void testXdiStatementsExtraction(RootNode p_graph, Class p_class) {
        System.out.println("Test xdi statements extraction " + p_class.getSimpleName() + "...");
        List extracted = TUtils.EXTRACTOR.extractXdiStatementList((XdiNode)p_graph);
        extracted.removeAll(this.expectedXdiStatementList());
        BaseTestCase.assertTrue((String)("Extractor extracts some xdi statements which is not expected: \n" + extracted), (boolean)extracted.isEmpty());
        System.out.println("--------- Test passed!");
    }
}

