/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.casa.core.model;

import java.util.List;
import java.util.Optional;
import org.gluu.casa.misc.Utils;
import org.gluu.model.SimpleCustomProperty;
import org.gluu.persist.model.base.Entry;
import org.gluu.site.ldap.persistence.annotation.LdapAttribute;
import org.gluu.site.ldap.persistence.annotation.LdapEntry;
import org.gluu.site.ldap.persistence.annotation.LdapJsonObject;
import org.gluu.site.ldap.persistence.annotation.LdapObjectClass;

@LdapEntry
@LdapObjectClass(values={"top", "oxCustomScript"})
public class CustomScript
extends Entry {
    @LdapAttribute
    private String displayName;
    @LdapAttribute(name="gluuStatus")
    private Boolean enabled;
    @LdapJsonObject
    @LdapAttribute(name="oxConfigurationProperty")
    private List<SimpleCustomProperty> configurationProperties;
    @LdapAttribute(name="oxLevel")
    private Integer level;
    @LdapJsonObject
    @LdapAttribute(name="oxModuleProperty")
    private List<SimpleCustomProperty> moduleProperties;
    @LdapAttribute(name="oxRevision")
    private Long revision;
    @LdapAttribute(name="oxScript")
    private String script;

    public String getDisplayName() {
        return this.displayName;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public boolean isEnabled() {
        return Optional.ofNullable(this.enabled).orElse(false);
    }

    public List<SimpleCustomProperty> getConfigurationProperties() {
        return this.configurationProperties;
    }

    public Integer getLevel() {
        return this.level;
    }

    public List<SimpleCustomProperty> getModuleProperties() {
        return Utils.nonNullList(this.moduleProperties);
    }

    public Long getRevision() {
        return this.revision;
    }

    public String getScript() {
        return this.script;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setConfigurationProperties(List<SimpleCustomProperty> configurationProperties) {
        this.configurationProperties = configurationProperties;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public void setModuleProperties(List<SimpleCustomProperty> moduleProperties) {
        this.moduleProperties = moduleProperties;
    }

    public void setRevision(Long revision) {
        this.revision = revision;
    }

    public void setScript(String script) {
        this.script = script;
    }
}

