/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.casa.core.model;

import java.util.Set;
import org.gluu.casa.misc.Utils;
import org.gluu.casa.service.IPersistenceService;
import org.gluu.persist.model.base.InumEntry;
import org.gluu.site.ldap.persistence.annotation.LdapAttribute;
import org.gluu.site.ldap.persistence.annotation.LdapCustomObjectClass;
import org.gluu.site.ldap.persistence.annotation.LdapEntry;
import org.gluu.site.ldap.persistence.annotation.LdapObjectClass;

@LdapEntry
@LdapObjectClass(values={"top", "gluuPerson"})
public class BasePerson
extends InumEntry {
    @LdapAttribute
    private String uid;
    @LdapCustomObjectClass
    private static String[] customObjectClasses;

    public String getUid() {
        return this.uid;
    }

    public static String[] getCustomObjectClasses() {
        return customObjectClasses;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public static void setCustomObjectClasses(String[] customObjectClasses) {
        BasePerson.customObjectClasses = customObjectClasses;
    }

    static {
        IPersistenceService ips = Utils.managedBean(IPersistenceService.class);
        if (ips != null) {
            Set<String> ocs = ips.getPersonOCs();
            ocs.remove("top");
            ocs.remove("gluuPerson");
            BasePerson.setCustomObjectClasses(ocs.toArray(new String[0]));
        }
    }
}

