/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.casa.ui;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import javax.servlet.ServletRequest;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Converter;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;

public class CustomDateConverter
implements Converter {
    public Object coerceToUi(Object val, Component comp, BindContext ctx) {
        long timeStamp;
        long l = timeStamp = val instanceof Date ? ((Date)val).getTime() : ((Long)val).longValue();
        if (timeStamp > 0L) {
            ZoneId zid;
            String format = (String)ctx.getConverterArg("format");
            Object offset = ctx.getConverterArg("offset");
            if (offset != null && ZoneId.class.isAssignableFrom(offset.getClass())) {
                zid = (ZoneId)offset;
            } else {
                zid = ZoneOffset.UTC;
                if (format.contains("hh") || format.contains("HH") || format.contains("mm")) {
                    format = format + " '(GMT)'";
                }
            }
            Instant instant = Instant.ofEpochMilli(timeStamp);
            OffsetDateTime odt = OffsetDateTime.ofInstant(instant, zid);
            ServletRequest request = (ServletRequest)Executions.getCurrent().getNativeRequest();
            Locale locale = request.getLocale() == null ? Locale.getDefault() : request.getLocale();
            return odt.format(DateTimeFormatter.ofPattern(format, locale));
        }
        return null;
    }

    public Object coerceToBean(Object val, Component comp, BindContext ctx) {
        return null;
    }
}

