/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.credmanager.misc;

import java.util.Arrays;
import org.gluu.credmanager.misc.Utils;
import org.gluu.credmanager.service.IExtensionsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.ContextClassLoaderFactory;

public class CustomClassLoader
implements ContextClassLoaderFactory {
    private static final String[] DEFAULT_PACKAGES = new String[]{"org.zkoss", "java", "javax"};
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private IExtensionsManager extManager = Utils.managedBean(IExtensionsManager.class);

    public CustomClassLoader() {
        if (this.extManager == null) {
            this.logger.error("Could not obtain a reference to ExtensionsManager bean");
        }
    }

    public ClassLoader getContextClassLoader(Class<?> reference) {
        return reference.getClassLoader();
    }

    public ClassLoader getContextClassLoaderForName(String className) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (Arrays.stream(DEFAULT_PACKAGES).anyMatch(pkg -> className.startsWith(pkg + ".")) || !Character.isLetter(className.charAt(0))) {
            return loader;
        }
        try {
            loader.loadClass(className);
            return loader;
        }
        catch (ClassNotFoundException e) {
            if (this.extManager != null) {
                loader = this.extManager.getPluginClassLoader(className);
                if (loader == null) {
                    this.logger.error("Could not find a plugin class loader for class '{}'", (Object)className);
                } else {
                    this.logger.trace("Class '{}' found in one of the plugins class loaders", (Object)className);
                }
            }
            return loader;
        }
    }
}

