/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.credmanager.core.ldap;

import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.persist.FilterUsage;
import com.unboundid.ldap.sdk.persist.LDAPEntryField;
import com.unboundid.ldap.sdk.persist.LDAPField;
import com.unboundid.ldap.sdk.persist.LDAPObject;
import java.util.List;
import org.gluu.credmanager.misc.Utils;

@LDAPObject(structuralClass="oxCustomScript", superiorClass={"top"})
public class oxCustomScript {
    @LDAPEntryField
    private ReadOnlyEntry ldapEntry;
    @LDAPField(inRDN=true, filterUsage=FilterUsage.ALWAYS_ALLOWED, requiredForEncode=true)
    private String[] inum;
    @LDAPField(filterUsage=FilterUsage.ALWAYS_ALLOWED)
    private String displayName;
    @LDAPField
    private String[] gluuStatus;
    @LDAPField
    private String[] oxConfigurationProperty;
    @LDAPField
    private String[] oxLevel;
    @LDAPField
    private String[] oxModuleProperty;
    @LDAPField
    private String[] oxRevision;
    @LDAPField
    private String[] oxScript;

    public String getDisplayName() {
        return this.displayName;
    }

    public List<String> getConfigurationProperties() {
        return Utils.listfromArray(this.oxConfigurationProperty);
    }

    public List<String> getModuleProperties() {
        return Utils.listfromArray(this.oxModuleProperty);
    }

    public String getScript() {
        if (this.oxScript == null || this.oxScript.length == 0) {
            return null;
        }
        return this.oxScript[0];
    }

    public String getRevision() {
        if (this.oxRevision == null || this.oxRevision.length == 0) {
            return null;
        }
        return this.oxRevision[0];
    }

    public boolean isEnabled() {
        return Utils.isNotEmpty(this.gluuStatus) && Boolean.parseBoolean(this.gluuStatus[0]);
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setRevision(String ... v) {
        this.oxRevision = v;
    }
}

