/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.cas.auth.handler;

import java.security.GeneralSecurityException;
import javax.security.auth.login.FailedLoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.gluu.oxauth.cas.auth.principal.ClientCredential;
import org.gluu.oxauth.client.Client;
import org.gluu.oxauth.client.auth.principal.OpenIdCredentials;
import org.gluu.oxauth.client.auth.user.UserProfile;
import org.jasig.cas.authentication.AuthenticationHandler;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.CredentialMetaData;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.SimplePrincipal;
import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.xdi.context.J2EContext;
import org.xdi.context.WebContext;
import org.xdi.util.StringHelper;

public final class ClientAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler {
    @NotNull
    private final Client<UserProfile> client;

    public ClientAuthenticationHandler(Client<UserProfile> client) {
        this.client = client;
    }

    public boolean supports(Credential credential) {
        return credential != null && ClientCredential.class.isAssignableFrom(credential.getClass());
    }

    protected HandlerResult doAuthentication(Credential credential) throws GeneralSecurityException, PreventedException {
        String id;
        ClientCredential clientCredentials = (ClientCredential)credential;
        OpenIdCredentials openIdCredentials = clientCredentials.getOpenIdCredentials();
        this.logger.debug("Client credentials : '{}'", (Object)clientCredentials);
        String clientName = openIdCredentials.getClientName();
        this.logger.debug("Client name : '{}'", (Object)clientName);
        ServletExternalContext servletExternalContext = (ServletExternalContext)ExternalContextHolder.getExternalContext();
        HttpServletRequest request = (HttpServletRequest)servletExternalContext.getNativeRequest();
        HttpServletResponse response = (HttpServletResponse)servletExternalContext.getNativeResponse();
        J2EContext webContext = new J2EContext(request, response);
        UserProfile userProfile = this.client.getUserProfile(openIdCredentials, (WebContext)webContext);
        this.logger.debug("userProfile : {}", (Object)userProfile);
        if (userProfile != null && StringHelper.isNotEmpty((String)(id = userProfile.getId()))) {
            openIdCredentials.setUserProfile(userProfile);
            return new HandlerResult((AuthenticationHandler)this, (CredentialMetaData)clientCredentials, (Principal)new SimplePrincipal(id, userProfile.getAttributes()));
        }
        throw new FailedLoginException("Provider did not produce profile for " + (Object)((Object)clientCredentials));
    }
}

