/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.cas.auth.login.flow;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.gluu.oxauth.cas.auth.client.AuthClient;
import org.gluu.oxauth.cas.auth.principal.ClientCredential;
import org.gluu.oxauth.client.auth.principal.OpenIdCredentials;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.xdi.context.J2EContext;
import org.xdi.context.WebContext;

public final class ClientAction
extends AbstractAction {
    private final Logger logger = LoggerFactory.getLogger(ClientAction.class);
    public static final String DEFAULT_CLIENT_NAME_PARAMETER = "client_name";
    public static final String SERVICE = "service";
    public static final String THEME = "theme";
    public static final String LOCALE = "locale";
    public static final String METHOD = "method";
    @NotNull
    private final AuthClient client;
    @NotNull
    private final CentralAuthenticationService centralAuthenticationService;

    public ClientAction(AuthClient client, CentralAuthenticationService centralAuthenticationService) {
        this.client = client;
        this.centralAuthenticationService = centralAuthenticationService;
    }

    protected Event doExecute(RequestContext context) throws Exception {
        HttpServletResponse response;
        HttpServletRequest request = WebUtils.getHttpServletRequest((RequestContext)context);
        J2EContext webContext = new J2EContext(request, response = WebUtils.getHttpServletResponse((RequestContext)context));
        if (this.client.isAuthorizationResponse((WebContext)webContext)) {
            this.logger.info("Procession authentication request");
            if (!this.client.isValidRequestState((WebContext)webContext)) {
                this.logger.warn("The state in session and in request are not equals");
                this.prepareForLoginPage(context, (WebContext)webContext);
                return new Event((Object)this, "stop");
            }
            ClientCredential credentials = this.getClientCrendentials(context, (WebContext)webContext);
            if (credentials != null) {
                WebUtils.putTicketGrantingTicketInRequestScope((RequestContext)context, (String)this.centralAuthenticationService.createTicketGrantingTicket(new Credential[]{credentials}));
                return this.success();
            }
        }
        this.prepareForLoginPage(context, (WebContext)webContext);
        return this.error();
    }

    private ClientCredential getClientCrendentials(RequestContext context, WebContext webContext) {
        OpenIdCredentials openIdCredentials = this.client.getCredentials(webContext);
        ClientCredential credentials = new ClientCredential(openIdCredentials);
        Service service = (Service)webContext.getSessionAttribute(SERVICE);
        if (service != null) {
            webContext.setRequestAttribute(SERVICE, (Object)service.getId());
        }
        context.getFlowScope().put(SERVICE, (Object)service);
        this.restoreRequestAttribute(webContext, THEME);
        this.restoreRequestAttribute(webContext, LOCALE);
        this.restoreRequestAttribute(webContext, METHOD);
        return credentials;
    }

    protected void prepareForLoginPage(RequestContext context, WebContext webContext) {
        Service service = (Service)context.getFlowScope().get(SERVICE);
        if (service != null) {
            webContext.setSessionAttribute(SERVICE, (Object)service);
        }
        this.saveRequestParameter(webContext, THEME);
        this.saveRequestParameter(webContext, LOCALE);
        this.saveRequestParameter(webContext, METHOD);
        String keyRedirectionUrl = this.client.getName() + "Url";
        String redirectionUrl = this.client.getRedirectionUrl(webContext);
        this.logger.debug("Generated redirection Url", (Object)redirectionUrl);
        context.getFlowScope().put(keyRedirectionUrl, (Object)redirectionUrl);
        String keyAuthMethod = this.client.getName() + "OpenIdDefaultAuthenticator";
        Boolean keyAuthMethodValue = this.client.isOpenIdDefaultAuthenticator();
        this.logger.debug("OpenIdDefaultAuthenticator", (Object)keyAuthMethodValue);
        context.getFlowScope().put(keyAuthMethod, (Object)keyAuthMethodValue);
    }

    private void restoreRequestAttribute(WebContext context, String name) {
        String value = (String)context.getSessionAttribute(name);
        context.setRequestAttribute(name, (Object)value);
    }

    private void saveRequestParameter(WebContext context, String name) {
        String value = context.getRequestParameter(name);
        if (value != null) {
            context.setSessionAttribute(name, (Object)value);
        }
    }
}

