/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.express.loader;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;

public class Util {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] extract(InputStream in) throws IOException {
        if (in == null) {
            throw new NullPointerException();
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] data = new byte[4096];
            int read = 0;
            while ((read = in.read(data, 0, data.length)) > 0) {
                out.write(data, 0, read);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            Util.closeQuietly(in);
        }
    }

    public static int getNumJarSeparators(String str) {
        int rv = 0;
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            if (ch != '!' || i >= length - 1 || str.charAt(i + 1) != '/') continue;
            ++rv;
        }
        return rv;
    }

    public static URL fixUpUrl(URL source) throws IOException {
        String extForm = source.toExternalForm();
        if (extForm.startsWith("vfs")) {
            URLConnection conn = source.openConnection();
            Object content = conn.getContent();
            try {
                Class<?> vfsUtilsClass = Class.forName("org.jboss.vfs.VFSUtils");
                Class<?> virtualFileClass = Class.forName("org.jboss.vfs.VirtualFile");
                Method getPathName = virtualFileClass.getDeclaredMethod("getPathName", new Class[0]);
                Method getPhysicalURL = vfsUtilsClass.getDeclaredMethod("getPhysicalURL", virtualFileClass);
                String pathName = (String)getPathName.invoke(content, (Object[])null);
                if (!new File(pathName).exists()) {
                    Object retVal = getPhysicalURL.invoke(null, content);
                    extForm = ((URL)retVal).toExternalForm();
                }
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        if (extForm.startsWith("vfs:") && extForm.contains("jar/META-INF")) {
            extForm = extForm.replaceFirst("vfs", "jar:file").replaceFirst("jar/META-INF", "jar!/META-INF");
        }
        if (extForm.startsWith("vfs:")) {
            extForm = extForm.replaceFirst("vfs", "file");
        }
        if (extForm.startsWith("jar:") && extForm.endsWith("!/") && Util.getNumJarSeparators(extForm) == 1) {
            extForm = extForm.substring("jar:".length(), extForm.length() - "!/".length());
        }
        if (!extForm.endsWith(".jar") && extForm.startsWith("jar:") && extForm.endsWith(".class") && extForm.contains(".jar!")) {
            extForm = extForm.substring(4, extForm.lastIndexOf(".jar!")) + ".jar";
        }
        return new URL(source, Util.canonicalize(extForm));
    }

    private static String canonicalize(String url) throws MalformedURLException {
        String[] urlParts = url.split("\\/");
        ArrayList<String> retainedParts = new ArrayList<String>();
        for (String part : urlParts) {
            if (part.equals(".")) continue;
            if (part.equals("..")) {
                if (retainedParts.isEmpty()) {
                    throw new MalformedURLException(url + " has too many \"..\" parts");
                }
                retainedParts.remove(retainedParts.size() - 1);
                continue;
            }
            retainedParts.add(part);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < retainedParts.size(); ++i) {
            sb.append((String)retainedParts.get(i));
            if (i >= retainedParts.size() - 1) continue;
            sb.append("/");
        }
        return sb.toString();
    }

    public static boolean isDirectoryUrl(URL url) {
        File file = Util.toFile(url);
        return file != null && file.isDirectory();
    }

    public static void closeQuietly(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(OutputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static int copy(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[4096];
        int count = 0;
        int n = 0;
        while (-1 != (n = in.read(buffer))) {
            out.write(buffer, 0, n);
            count += n;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File srcFile, File destFile) throws IOException {
        FileInputStream input = new FileInputStream(srcFile);
        try {
            FileOutputStream output = new FileOutputStream(destFile);
            try {
                Util.copy(input, output);
            }
            finally {
                Util.closeQuietly(output);
            }
        }
        finally {
            Util.closeQuietly(input);
        }
    }

    public static URL toURL(File file) throws MalformedURLException {
        return file.toURI().toURL();
    }

    public static File toFile(URL url) {
        if (!url.toExternalForm().startsWith("file")) {
            return null;
        }
        String path = url.getPath();
        try {
            return new File(URLDecoder.decode(path, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}

