/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.express.loader;

import com.terracotta.express.loader.Jar;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarManager {
    private static final long DEFAULT_IDLE_TIME = 10000L;
    private static final long IDLE_TIME;
    private final Map<String, Jar> jars = new LinkedHashMap<String, Jar>();
    private final long idleTime;
    private Thread idleThread;

    public JarManager() {
        this(IDLE_TIME);
    }

    public JarManager(long idleTime) {
        this.idleTime = idleTime;
    }

    public synchronized Jar getOrCreate(String key, URL source) {
        if (source == null) {
            throw new NullPointerException("null source");
        }
        if (key == null) {
            throw new NullPointerException("key source");
        }
        Jar jar = this.jars.get(key);
        if (jar == null) {
            jar = new Jar(source, this);
            this.jars.put(key, jar);
        }
        return jar;
    }

    public synchronized Jar get(String key) {
        if (key == null) {
            throw new NullPointerException("null source");
        }
        return this.jars.get(key);
    }

    synchronized void jarOpened(Jar jar) {
        if (this.idleThread == null) {
            this.idleThread = new IdleThread(this, this.idleTime);
            this.idleThread.start();
        }
    }

    private synchronized Collection<Jar> getJarsSnapshot() {
        return new ArrayList<Jar>(this.jars.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reapIdleJars() {
        boolean anyOpen = false;
        boolean reaped = false;
        while (!reaped) {
            Collection<Jar> snapshot = this.getJarsSnapshot();
            for (Jar jar : snapshot) {
                jar.lock();
            }
            JarManager jarManager = this;
            synchronized (jarManager) {
                try {
                    if (((Object)snapshot).equals(this.getJarsSnapshot())) {
                        reaped = true;
                        for (Jar jar : this.jars.values()) {
                            if (jar.deflateIfIdle(this.idleTime)) continue;
                            anyOpen = true;
                        }
                        if (!anyOpen) {
                            this.idleThread = null;
                        }
                    }
                }
                finally {
                    for (Jar jar : snapshot) {
                        jar.unlock();
                    }
                }
            }
        }
        return !anyOpen;
    }

    static {
        long idle = 10000L;
        String prop = System.getProperty(JarManager.class.getName() + ".idle");
        if (prop != null && (idle = Long.valueOf(prop).longValue()) < 100L) {
            idle = 100L;
        }
        IDLE_TIME = idle;
    }

    private static class IdleThread
    extends Thread {
        private final long idle;
        private final JarManager manager;

        IdleThread(JarManager manager, long idle) {
            this.manager = manager;
            this.idle = idle;
            this.setName("JarManager idle thread");
            this.setDaemon(true);
        }

        public void run() {
            long sleep = Math.max(1000L, this.idle / 10L);
            do {
                try {
                    IdleThread.sleep(sleep);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (!this.manager.reapIdleJars());
        }
    }
}

