/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.express.loader;

import org.terracotta.agent.repkg.de.schlichtherle.io.rof.AbstractReadOnlyFile;

class ByteArrayReadOnlyFile
extends AbstractReadOnlyFile {
    private final byte[] data;
    private int index = 0;

    ByteArrayReadOnlyFile(byte[] data) {
        this.data = data;
    }

    public void close() {
    }

    public long getFilePointer() {
        return this.index;
    }

    public long length() {
        return this.data.length;
    }

    public int read() {
        if (this.index >= this.data.length) {
            return -1;
        }
        return this.data[this.index++];
    }

    public int read(byte[] b, int off, int len) {
        if (this.index >= this.data.length) {
            return -1;
        }
        len = Math.min(this.data.length - this.index, len);
        System.arraycopy(this.data, this.index, b, off, len);
        this.index += len;
        return len;
    }

    public void seek(long pos) {
        this.index = (int)pos;
    }
}

