/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.express;

import com.terracotta.express.BootjarLoader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClusteredStateLoader
extends URLClassLoader {
    private static final boolean USE_APP_JTA_CLASSES;
    private final ClassLoader appLoader;
    private volatile ClassFileTransformer transformer;
    private final Set<String> publicApiClasses;
    private final Map<String, byte[]> extraClasses = new ConcurrentHashMap<String, byte[]>();

    ClusteredStateLoader(URL[] urls, BootjarLoader bootJarLoader, ClassLoader appLoader) {
        super(urls, (ClassLoader)bootJarLoader);
        this.appLoader = appLoader;
        this.publicApiClasses = new CopyOnWriteArraySet<String>();
    }

    void addExtraClass(String name, byte[] classBytes) {
        this.extraClasses.put(name, classBytes);
    }

    void addPublicApiTypes(Set<String> addedPublicApiClasses) {
        this.publicApiClasses.addAll(addedPublicApiClasses);
    }

    void addPublicApiType(String addedPublicApiClass) {
        this.publicApiClasses.add(addedPublicApiClass);
    }

    @Override
    protected void addURL(URL url) {
        super.addURL(url);
    }

    synchronized void setTransformer(ClassFileTransformer transformer) {
        this.transformer = transformer;
        this.notifyAll();
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream in = this.getParent().getResourceAsStream(name);
        if (in != null) {
            return in;
        }
        return this.appLoader.getResourceAsStream(name);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> rv = this.loadClass(name);
        if (resolve) {
            this.resolveClass(rv);
        }
        return rv;
    }

    @Override
    public synchronized Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> rv = this.findLoadedClass(name);
        if (rv != null) {
            return rv;
        }
        byte[] extra = this.extraClasses.remove(name);
        if (extra != null) {
            extra = this.transform(name, extra);
            return this.defineClass(name, extra, 0, extra.length);
        }
        if (USE_APP_JTA_CLASSES && name.startsWith("javax.transaction.")) {
            return this.appLoader.loadClass(name);
        }
        try {
            return this.getParent().loadClass(name);
        }
        catch (ClassNotFoundException cnfe) {
            if (this.publicApiClasses.contains(name)) {
                return this.appLoader.loadClass(name);
            }
            String resName = name.replace('.', '/').concat(".class");
            URL resource = this.getResource(resName);
            if (resource != null) {
                byte[] clazzBytes;
                try {
                    clazzBytes = this.readResource(resource);
                }
                catch (IOException ioe) {
                    throw new ClassNotFoundException(name, ioe);
                }
                clazzBytes = this.transform(name, clazzBytes);
                return this.defineClass(name, clazzBytes, 0, clazzBytes.length);
            }
            try {
                return this.appLoader.loadClass(name);
            }
            catch (ClassNotFoundException cnfe2) {
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                if (contextClassLoader != this && contextClassLoader != this.appLoader && contextClassLoader != this.getParent()) {
                    return contextClassLoader.loadClass(name);
                }
                throw cnfe2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] transform(String name, byte[] data) throws AssertionError {
        ClassFileTransformer cft = this.transformer;
        if (cft == null) {
            ClusteredStateLoader clusteredStateLoader = this;
            synchronized (clusteredStateLoader) {
                while (this.transformer == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        return data;
                    }
                }
                cft = this.transformer;
            }
        }
        try {
            return cft.transform(this, name, null, null, data);
        }
        catch (IllegalClassFormatException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readResource(URL resource) throws IOException {
        InputStream in = null;
        try {
            int read;
            in = resource.openStream();
            byte[] buf = new byte[4096];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((read = in.read(buf)) > 0) {
                baos.write(buf, 0, read);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    static {
        String prop = System.getProperty(ClusteredStateLoader.class.getName() + ".USE_APP_JTA_CLASSES", "true");
        prop = prop.trim();
        USE_APP_JTA_CLASSES = Boolean.valueOf(prop);
    }
}

