/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.express;

import com.terracotta.express.AppClassLoader;
import com.terracotta.express.BootjarLoader;
import com.terracotta.express.ClientFactoryImpl;
import com.terracotta.express.ClusteredStateLoader;
import com.terracotta.express.DSOContextControl;
import com.terracotta.express.L1Loader;
import com.terracotta.express.StandaloneL1Boot;
import com.terracotta.express.URLConfigUtil;
import com.terracotta.express.loader.Handler;
import com.terracotta.express.loader.Jar;
import com.terracotta.express.loader.JarManager;
import com.terracotta.express.loader.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.instrument.ClassFileTransformer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.JarInputStream;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.terracotta.express.Client;
import org.terracotta.util.FindbugsSuppressWarnings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClientImpl
implements Client {
    private static final boolean DEBUG_ON = Boolean.getBoolean("com.terracotta.express.debug");
    private static final Logger LOG = Logger.getLogger("com.terracotta.express.ClientImpl");
    private final BootjarLoader bootJarLoader;
    private final ClusteredStateLoader clusteredStateLoader;
    private final AppClassLoader appClassLoader;
    private final JarManager jarManager;
    private final DSOContextControl contextControl;
    private final Map<Class, Boolean> introspected = new WeakHashMap<Class, Boolean>();
    private final AtomicInteger refCount = new AtomicInteger(1);
    private final ClientFactoryImpl parent;
    private final String tcConfig;
    private boolean shutdown = false;
    private final boolean isUrlConfig;
    private final boolean dedicatedClient;
    private final boolean rejoinClient;

    boolean isDedicatedClient() {
        return this.dedicatedClient;
    }

    boolean isRejoinClient() {
        return this.rejoinClient;
    }

    synchronized void join(Class[] introspectionSources) throws ClientShutdownException {
        if (this.shutdown) {
            throw new ClientShutdownException();
        }
        this.refCount.incrementAndGet();
        Collection<URL> modules = this.introspectModules(introspectionSources);
        try {
            this.contextControl.addModules(modules.toArray(new URL[0]));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FindbugsSuppressWarnings(value={"DMI_COLLECTION_OF_URLS"})
    private Collection<URL> introspectModules(Class[] sources) {
        Collection<URL> modules = new HashSet<URL>();
        if (sources != null) {
            for (Class source : sources) {
                Map<Class, Boolean> map = this.introspected;
                synchronized (map) {
                    if (this.introspected.containsKey(source)) {
                        continue;
                    }
                    this.introspected.put(source, Boolean.TRUE);
                    this.appClassLoader.addLoader(source.getClassLoader());
                }
                try {
                    URL sourceJar = source.getProtectionDomain().getCodeSource().getLocation();
                    this.debugLog("Raw sourceJar=%s", sourceJar);
                    String jarName = new File(sourceJar.toExternalForm()).getName();
                    sourceJar = Util.fixUpUrl(sourceJar);
                    this.debugLog("Fixed sourceJar=%s", sourceJar);
                    if (Util.isDirectoryUrl(sourceJar)) {
                        this.debugLog("sourceJar is a directory", new Object[0]);
                        File dir = new File(sourceJar.toURI());
                        File jarFile = new File(new File(dir, ".."), jarName);
                        if (jarFile.exists() && jarName.endsWith(".jar")) {
                            sourceJar = jarFile.getCanonicalFile().toURI().toURL();
                            this.debugLog("jarFile exist: %s. Handling sourceJar %s as url", jarFile, sourceJar);
                            modules = this.handleJarUrl(sourceJar, source.getClassLoader());
                        } else {
                            this.debugLog("jarFile doesn't exist: %s. Handling sourceJar as directory", jarFile);
                            modules = this.handleDirectoryUrl(sourceJar, source.getClassLoader());
                        }
                    } else {
                        this.debugLog("sourceJar is a not a directory, handling it as url", new Object[0]);
                        modules = this.handleJarUrl(sourceJar, source.getClassLoader());
                    }
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
                for (URL url : modules) {
                    this.clusteredStateLoader.addURL(url);
                }
            }
        }
        return modules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<URL> handleDirectoryUrl(URL sourceJar, ClassLoader loader) throws IOException, URISyntaxException {
        FileInputStream publicTypeIn = null;
        HashSet<URL> modules = new HashSet<URL>();
        File dir = new File(sourceJar.toURI());
        LinkedList<File> list = new LinkedList<File>();
        list.addAll(Arrays.asList(dir.listFiles()));
        try {
            while (!list.isEmpty()) {
                File entry = (File)list.remove(0);
                if (entry.isDirectory()) {
                    list.addAll(Arrays.asList(entry.listFiles()));
                    continue;
                }
                if (entry.getAbsolutePath().contains("META-INF" + File.separator + "terracotta" + File.separator + "TIMs" + File.separator) && entry.getName().endsWith(".jar")) {
                    URL url = Util.toURL(entry);
                    Jar jar = this.jarManager.getOrCreate(url.toExternalForm(), url);
                    modules.add(this.newTcJarUrl(jar.getSource()));
                }
                if (!entry.getAbsolutePath().contains("META-INF" + File.separator + "terracotta" + File.separator + "public-api-types")) continue;
                publicTypeIn = new FileInputStream(entry);
                this.clusteredStateLoader.addPublicApiTypes(this.readPublicApiTypes(publicTypeIn));
            }
        }
        finally {
            Util.closeQuietly(publicTypeIn);
        }
        return modules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<URL> handleJarUrl(URL sourceJar, ClassLoader loader) throws IOException {
        HashSet<URL> modules = new HashSet<URL>();
        InputStream in = null;
        JarInputStream jarIn = null;
        try {
            ZipEntry entry;
            in = sourceJar.openStream();
            jarIn = new JarInputStream(in);
            while ((entry = jarIn.getNextEntry()) != null) {
                String entryName = entry.getName();
                if (entryName.startsWith("META-INF/terracotta/TIMs/") && entryName.endsWith(".jar")) {
                    URL url = loader.getResource(entryName);
                    url = Util.fixUpUrl(url);
                    Jar jar = this.jarManager.getOrCreate(url.toExternalForm(), url);
                    modules.add(this.newTcJarUrl(jar.getSource()));
                }
                if (!entryName.equals("META-INF/terracotta/public-api-types")) continue;
                this.clusteredStateLoader.addPublicApiTypes(this.readPublicApiTypes(jarIn));
            }
        }
        catch (Throwable throwable) {
            Util.closeQuietly(in);
            Util.closeQuietly(jarIn);
            throw throwable;
        }
        Util.closeQuietly(in);
        Util.closeQuietly(jarIn);
        return modules;
    }

    private Set<String> readPublicApiTypes(InputStream in) throws IOException {
        String line;
        LinkedHashSet<String> rv = new LinkedHashSet<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        while ((line = reader.readLine()) != null) {
            line = line.replace('/', '.');
            line = line.replaceAll(".class$", "");
            rv.add(line);
        }
        return rv;
    }

    @Override
    public <T> T instantiate(String className, Class[] cstrArgTypes, Object[] cstrArgs) throws Exception {
        Class<?> clazz = this.clusteredStateLoader.loadClass(className);
        Constructor<?> cstr = clazz.getConstructor(cstrArgTypes);
        return (T)cstr.newInstance(cstrArgs);
    }

    @Override
    public <T> T staticFactoryMethod(String className, String methodName, Class[] argTypes, Object[] args) throws Exception {
        Class<?> clazz = this.clusteredStateLoader.loadClass(className);
        Method method = clazz.getMethod(methodName, argTypes);
        return (T)method.invoke((Object)args, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void shutdown() {
        boolean shutdownClient = false;
        if (this.isDedicatedClient()) {
            shutdownClient = true;
        } else {
            int count = this.refCount.decrementAndGet();
            if (count < 0) {
                throw new IllegalStateException("shutdown() called too many times, this represents a bug in the caller. count = " + count);
            }
            boolean bl = shutdownClient = count == 0;
        }
        if (shutdownClient) {
            this.shutdown = true;
            try {
                this.contextControl.shutdown();
            }
            finally {
                this.appClassLoader.clear();
                this.parent.remove(this, this.tcConfig, this.isUrlConfig);
            }
        }
    }

    private byte[] getBootClassBytes() {
        ClassLoader loader = this.getClass().getClassLoader();
        String res = StandaloneL1Boot.class.getName().replace('.', '/').concat(".class");
        try {
            return Util.extract(loader.getResourceAsStream(res));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] getURLConfigUtilClassBytes() {
        ClassLoader loader = this.getClass().getClassLoader();
        String res = URLConfigUtil.class.getName().replace('.', '/').concat(".class");
        try {
            return Util.extract(loader.getResourceAsStream(res));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private URL[] toURLs(List<Jar> jars) throws IOException {
        Jar[] jarArray = jars.toArray(new Jar[0]);
        URL[] urls = new URL[jarArray.length];
        for (int i = 0; i < jarArray.length; ++i) {
            urls[i] = this.newTcJarUrl(jarArray[i].getSource());
        }
        return urls;
    }

    private L1Loader newL1Loader(List<Jar> l1Jars) throws IOException {
        HashMap<String, byte[]> extraClasses = new HashMap<String, byte[]>();
        extraClasses.put(StandaloneL1Boot.class.getName(), this.getBootClassBytes());
        extraClasses.put(URLConfigUtil.class.getName(), this.getURLConfigUtilClassBytes());
        return new L1Loader(this.toURLs(l1Jars), this.bootJarLoader, extraClasses, this.getForbiddenTypesForL1());
    }

    private Set<String> getForbiddenTypesForL1() {
        return Collections.EMPTY_SET;
    }

    ClientImpl(String tcConfig, boolean isUrlConfig, JarManager jarManager, URL[] timJars, ClassLoader appLoader, Map<String, URL> virtualTimJars, List<Jar> l1Jars, URL bootJarUrl, Class[] moduleIntrospectionSources, ClientFactoryImpl parent, boolean dedicatedClient, boolean rejoinClient) {
        this.dedicatedClient = dedicatedClient;
        this.rejoinClient = rejoinClient;
        this.tcConfig = tcConfig;
        this.isUrlConfig = isUrlConfig;
        this.jarManager = jarManager;
        this.parent = parent;
        try {
            this.appClassLoader = new AppClassLoader(appLoader);
            this.bootJarLoader = new BootjarLoader(this.newTcJarUrl(bootJarUrl), Collections.EMPTY_SET);
            L1Loader clientLoader = this.newL1Loader(l1Jars);
            this.clusteredStateLoader = new ClusteredStateLoader(timJars, this.bootJarLoader, (ClassLoader)this.appClassLoader);
            this.clusteredStateLoader.addPublicApiType("org.terracotta.api.ClusteringToolkit");
            this.clusteredStateLoader.addPublicApiType("org.terracotta.api.ClusteringToolkitExtension");
            this.clusteredStateLoader.addPublicApiType("org.terracotta.cluster.ClusterEvent");
            this.clusteredStateLoader.addPublicApiType("org.terracotta.cluster.ClusterEvent$Type");
            this.clusteredStateLoader.addPublicApiType("org.terracotta.cluster.ClusterInfo");
            this.clusteredStateLoader.addPublicApiType("org.terracotta.cluster.ClusterListener");
            this.clusteredStateLoader.addPublicApiType("org.terracotta.cluster.ClusterLogger");
            this.clusteredStateLoader.addPublicApiType("org.terracotta.cluster.ClusterNode");
            this.clusteredStateLoader.addPublicApiType("org.terracotta.cluster.ClusterProperties");
            this.clusteredStateLoader.addPublicApiType("org.terracotta.cluster.ClusterTopology");
            this.clusteredStateLoader.addPublicApiType("org.terracotta.cluster.UnclusteredObjectException");
            this.clusteredStateLoader.addPublicApiType("org.terracotta.collections.ClusteredMap");
            this.clusteredStateLoader.addPublicApiType("org.terracotta.collections.MapSizeListener");
            this.clusteredStateLoader.addPublicApiType("org.terracotta.coordination.Barrier");
            this.clusteredStateLoader.addPublicApiType("org.terracotta.locking.ClusteredLock");
            this.clusteredStateLoader.addPublicApiType("org.terracotta.locking.LockableMap");
            this.clusteredStateLoader.addPublicApiType("org.terracotta.locking.LockStrategy");
            this.clusteredStateLoader.addPublicApiType("org.terracotta.locking.GenericLockStrategy");
            this.clusteredStateLoader.addPublicApiType("org.terracotta.locking.LockType");
            this.clusteredStateLoader.addPublicApiType("org.terracotta.util.ClusteredAtomicLong");
            this.clusteredStateLoader.addPublicApiType("org.terracotta.util.ClusteredTextBucket");
            this.clusteredStateLoader.addExtraClass("com.terracotta.express.SpiInit", Util.extract(appLoader.getResourceAsStream("com/terracotta/express/SpiInit.class")));
            Collection<URL> modules = this.introspectModules(moduleIntrospectionSources);
            Class<?> bootClass = clientLoader.loadClass(StandaloneL1Boot.class.getName());
            Constructor<?> cstr = bootClass.getConstructor(Map.class, Collection.class, String.class, Boolean.TYPE, ClassLoader.class, URL.class, Boolean.TYPE);
            Callable boot = (Callable)cstr.newInstance(virtualTimJars, modules, tcConfig, isUrlConfig, this.clusteredStateLoader, this.newTcJarUrl(bootJarUrl), this.isRejoinClient());
            Object context = boot.call();
            this.clusteredStateLoader.setTransformer((ClassFileTransformer)context);
            Class<?> spiInit = this.clusteredStateLoader.loadClass("com.terracotta.express.SpiInit");
            this.contextControl = (DSOContextControl)spiInit.getConstructor(Object.class).newInstance(context);
            this.contextControl.init();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private URL newTcJarUrl(URL embedded) throws IOException {
        URL fixedEmbbeded = Util.fixUpUrl(embedded);
        return new URL("tcjar", "", -1, "__TC__" + fixedEmbbeded.toExternalForm() + "__TC__" + "/", new Handler(this.jarManager));
    }

    private void debugLog(String message, Object ... objects) {
        if (DEBUG_ON) {
            LOG.info(String.format("XXX: " + message, objects));
        }
    }

    static class ClientShutdownException
    extends Exception {
        ClientShutdownException() {
        }
    }
}

