/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.express;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AppClassLoader
extends ClassLoader {
    private static final Enumeration<URL> EMPTY_URL_ENUMERATION = new EmptyEnumeration<URL>();
    private final List<WeakReference<ClassLoader>> loaders = new CopyOnWriteArrayList<WeakReference<ClassLoader>>();
    private final ReferenceQueue<ClassLoader> refQueue = new ReferenceQueue();

    AppClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        for (ClassLoader loader : this.loaders()) {
            try {
                return loader.loadClass(name);
            }
            catch (ClassNotFoundException cnfe) {
            }
        }
        return super.findClass(name);
    }

    private Iterable<ClassLoader> loaders() {
        this.reap();
        final Iterator<WeakReference<ClassLoader>> iter = this.loaders.iterator();
        return new Iterable<ClassLoader>(){

            @Override
            public Iterator<ClassLoader> iterator() {
                return new Iterator<ClassLoader>(){
                    private ClassLoader loader;
                    {
                        this.advance();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.loader != null;
                    }

                    private void advance() {
                        this.loader = null;
                        while (iter.hasNext()) {
                            ClassLoader cl = (ClassLoader)((WeakReference)iter.next()).get();
                            if (cl == null) continue;
                            this.loader = cl;
                            return;
                        }
                    }

                    @Override
                    public ClassLoader next() {
                        ClassLoader rv = this.loader;
                        if (rv == null) {
                            throw new NoSuchElementException();
                        }
                        this.advance();
                        return rv;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private void reap() {
        Reference<ClassLoader> ref;
        while ((ref = this.refQueue.poll()) != null) {
            this.loaders.remove(ref);
        }
    }

    @Override
    protected URL findResource(String name) {
        for (ClassLoader loader : this.loaders()) {
            URL resource = loader.getResource(name);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        for (ClassLoader loader : this.loaders()) {
            Enumeration<URL> resources = loader.getResources(name);
            if (!resources.hasMoreElements()) continue;
            return resources;
        }
        return EMPTY_URL_ENUMERATION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLoader(ClassLoader loader) {
        if (loader == null) {
            throw new NullPointerException("null loader");
        }
        AppClassLoader appClassLoader = this;
        synchronized (appClassLoader) {
            for (ClassLoader cl : this.loaders()) {
                if (cl != loader) continue;
                return;
            }
            this.loaders.add(new WeakReference<ClassLoader>(loader, this.refQueue));
        }
    }

    void clear() {
        this.loaders.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyEnumeration<T>
    implements Enumeration<T> {
        private EmptyEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public T nextElement() {
            throw new NoSuchElementException();
        }
    }
}

