/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core.http.converter;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.http.converter.HttpMessageConverters;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class OAuth2ErrorHttpMessageConverter
extends AbstractHttpMessageConverter<OAuth2Error> {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final ParameterizedTypeReference<Map<String, String>> PARAMETERIZED_RESPONSE_TYPE = new ParameterizedTypeReference<Map<String, String>>(){};
    private GenericHttpMessageConverter<Object> jsonMessageConverter = HttpMessageConverters.getJsonMessageConverter();
    protected Converter<Map<String, String>, OAuth2Error> errorConverter = new OAuth2ErrorConverter();
    protected Converter<OAuth2Error, Map<String, String>> errorParametersConverter = new OAuth2ErrorParametersConverter();

    public OAuth2ErrorHttpMessageConverter() {
        super(DEFAULT_CHARSET, new MediaType[]{MediaType.APPLICATION_JSON, new MediaType("application", "*+json")});
    }

    protected boolean supports(Class<?> clazz) {
        return OAuth2Error.class.isAssignableFrom(clazz);
    }

    protected OAuth2Error readInternal(Class<? extends OAuth2Error> clazz, HttpInputMessage inputMessage) throws HttpMessageNotReadableException {
        try {
            Map errorParameters = (Map)this.jsonMessageConverter.read(PARAMETERIZED_RESPONSE_TYPE.getType(), null, inputMessage);
            return (OAuth2Error)this.errorConverter.convert((Object)errorParameters);
        }
        catch (Exception ex) {
            throw new HttpMessageNotReadableException("An error occurred reading the OAuth 2.0 Error: " + ex.getMessage(), (Throwable)ex, inputMessage);
        }
    }

    protected void writeInternal(OAuth2Error oauth2Error, HttpOutputMessage outputMessage) throws HttpMessageNotWritableException {
        try {
            Map errorParameters = (Map)this.errorParametersConverter.convert((Object)oauth2Error);
            this.jsonMessageConverter.write((Object)errorParameters, PARAMETERIZED_RESPONSE_TYPE.getType(), MediaType.APPLICATION_JSON, outputMessage);
        }
        catch (Exception ex) {
            throw new HttpMessageNotWritableException("An error occurred writing the OAuth 2.0 Error: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public final void setErrorConverter(Converter<Map<String, String>, OAuth2Error> errorConverter) {
        Assert.notNull(errorConverter, (String)"errorConverter cannot be null");
        this.errorConverter = errorConverter;
    }

    public final void setErrorParametersConverter(Converter<OAuth2Error, Map<String, String>> errorParametersConverter) {
        Assert.notNull(errorParametersConverter, (String)"errorParametersConverter cannot be null");
        this.errorParametersConverter = errorParametersConverter;
    }

    private static class OAuth2ErrorParametersConverter
    implements Converter<OAuth2Error, Map<String, String>> {
        private OAuth2ErrorParametersConverter() {
        }

        public Map<String, String> convert(OAuth2Error oauth2Error) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("error", oauth2Error.getErrorCode());
            if (StringUtils.hasText((String)oauth2Error.getDescription())) {
                parameters.put("error_description", oauth2Error.getDescription());
            }
            if (StringUtils.hasText((String)oauth2Error.getUri())) {
                parameters.put("error_uri", oauth2Error.getUri());
            }
            return parameters;
        }
    }

    private static class OAuth2ErrorConverter
    implements Converter<Map<String, String>, OAuth2Error> {
        private OAuth2ErrorConverter() {
        }

        public OAuth2Error convert(Map<String, String> parameters) {
            String errorCode = parameters.get("error");
            String errorDescription = parameters.get("error_description");
            String errorUri = parameters.get("error_uri");
            return new OAuth2Error(errorCode, errorDescription, errorUri);
        }
    }
}

