/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.oidc.web.logout;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;
import org.springframework.util.Assert;
import org.springframework.web.util.UriComponentsBuilder;

public final class OidcClientInitiatedLogoutSuccessHandler
extends SimpleUrlLogoutSuccessHandler {
    private final ClientRegistrationRepository clientRegistrationRepository;
    private URI postLogoutRedirectUri;

    public OidcClientInitiatedLogoutSuccessHandler(ClientRegistrationRepository clientRegistrationRepository) {
        Assert.notNull((Object)clientRegistrationRepository, (String)"clientRegistrationRepository cannot be null");
        this.clientRegistrationRepository = clientRegistrationRepository;
    }

    protected String determineTargetUrl(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        URI endSessionEndpoint;
        String targetUrl = null;
        if (authentication instanceof OAuth2AuthenticationToken && authentication.getPrincipal() instanceof OidcUser && (endSessionEndpoint = this.endSessionEndpoint((OAuth2AuthenticationToken)authentication)) != null) {
            targetUrl = this.endpointUri(endSessionEndpoint, authentication);
        }
        if (targetUrl == null) {
            targetUrl = super.determineTargetUrl(request, response);
        }
        return targetUrl;
    }

    private URI endSessionEndpoint(OAuth2AuthenticationToken token) {
        Object endSessionEndpoint;
        String registrationId = token.getAuthorizedClientRegistrationId();
        ClientRegistration clientRegistration = this.clientRegistrationRepository.findByRegistrationId(registrationId);
        URI result = null;
        if (clientRegistration != null && (endSessionEndpoint = clientRegistration.getProviderDetails().getConfigurationMetadata().get("end_session_endpoint")) != null) {
            result = URI.create(endSessionEndpoint.toString());
        }
        return result;
    }

    private String endpointUri(URI endSessionEndpoint, Authentication authentication) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)endSessionEndpoint);
        builder.queryParam("id_token_hint", new Object[]{this.idToken(authentication)});
        if (this.postLogoutRedirectUri != null) {
            builder.queryParam("post_logout_redirect_uri", new Object[]{this.postLogoutRedirectUri});
        }
        return builder.encode(StandardCharsets.UTF_8).build().toUriString();
    }

    private String idToken(Authentication authentication) {
        return ((OidcUser)authentication.getPrincipal()).getIdToken().getTokenValue();
    }

    public void setPostLogoutRedirectUri(URI postLogoutRedirectUri) {
        Assert.notNull((Object)postLogoutRedirectUri, (String)"postLogoutRedirectUri cannot be null");
        this.postLogoutRedirectUri = postLogoutRedirectUri;
    }
}

