/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.access.expression.method;

import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.expression.MethodBasedEvaluationContext;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.parameters.DefaultSecurityParameterNameDiscoverer;

class MethodSecurityEvaluationContext
extends MethodBasedEvaluationContext {
    private static final Log logger = LogFactory.getLog(MethodSecurityEvaluationContext.class);

    MethodSecurityEvaluationContext(Authentication user, MethodInvocation mi) {
        this(user, mi, (ParameterNameDiscoverer)new DefaultSecurityParameterNameDiscoverer());
    }

    MethodSecurityEvaluationContext(Authentication user, MethodInvocation mi, ParameterNameDiscoverer parameterNameDiscoverer) {
        super(mi.getThis(), MethodSecurityEvaluationContext.getSpecificMethod(mi), mi.getArguments(), parameterNameDiscoverer);
    }

    private static Method getSpecificMethod(MethodInvocation mi) {
        return AopUtils.getMostSpecificMethod((Method)mi.getMethod(), (Class)AopProxyUtils.ultimateTargetClass((Object)mi.getThis()));
    }
}

