/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.provisioning;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.core.userdetails.memory.UserAttribute;
import org.springframework.security.core.userdetails.memory.UserAttributeEditor;
import org.springframework.security.provisioning.MutableUser;
import org.springframework.security.provisioning.MutableUserDetails;
import org.springframework.security.provisioning.UserDetailsManager;
import org.springframework.util.Assert;

public class InMemoryUserDetailsManager
implements UserDetailsManager {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Map<String, MutableUserDetails> users = new HashMap<String, MutableUserDetails>();
    private AuthenticationManager authenticationManager;

    public InMemoryUserDetailsManager(Collection<UserDetails> users) {
        for (UserDetails user : users) {
            this.createUser(user);
        }
    }

    public InMemoryUserDetailsManager(Properties users) {
        Enumeration<?> names = users.propertyNames();
        UserAttributeEditor editor = new UserAttributeEditor();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            editor.setAsText(users.getProperty(name));
            UserAttribute attr = (UserAttribute)editor.getValue();
            User user = new User(name, attr.getPassword(), attr.isEnabled(), true, true, true, attr.getAuthorities());
            this.createUser(user);
        }
    }

    @Override
    public void createUser(UserDetails user) {
        Assert.isTrue((!this.userExists(user.getUsername()) ? 1 : 0) != 0);
        this.users.put(user.getUsername().toLowerCase(), new MutableUser(user));
    }

    @Override
    public void deleteUser(String username) {
        this.users.remove(username.toLowerCase());
    }

    @Override
    public void updateUser(UserDetails user) {
        Assert.isTrue((boolean)this.userExists(user.getUsername()));
        this.users.put(user.getUsername().toLowerCase(), new MutableUser(user));
    }

    @Override
    public boolean userExists(String username) {
        return this.users.containsKey(username.toLowerCase());
    }

    @Override
    public void changePassword(String oldPassword, String newPassword) {
        Authentication currentUser = SecurityContextHolder.getContext().getAuthentication();
        if (currentUser == null) {
            throw new AccessDeniedException("Can't change password as no Authentication object found in context for current user.");
        }
        String username = currentUser.getName();
        this.logger.debug((Object)("Changing password for user '" + username + "'"));
        if (this.authenticationManager != null) {
            this.logger.debug((Object)("Reauthenticating user '" + username + "' for password change request."));
            this.authenticationManager.authenticate(new UsernamePasswordAuthenticationToken(username, oldPassword));
        } else {
            this.logger.debug((Object)"No authentication manager set. Password won't be re-checked.");
        }
        MutableUserDetails user = this.users.get(username);
        if (user == null) {
            throw new IllegalStateException("Current user doesn't exist in database.");
        }
        user.setPassword(newPassword);
    }

    @Override
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        UserDetails user = this.users.get(username.toLowerCase());
        if (user == null) {
            throw new UsernameNotFoundException(username);
        }
        return new User(user.getUsername(), user.getPassword(), user.isEnabled(), user.isAccountNonExpired(), user.isCredentialsNonExpired(), user.isAccountNonLocked(), user.getAuthorities());
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }
}

