/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authentication.encoding;

import java.util.Locale;
import org.springframework.security.authentication.encoding.BasePasswordEncoder;
import org.springframework.security.authentication.encoding.PasswordEncoderUtils;

public class PlaintextPasswordEncoder
extends BasePasswordEncoder {
    private boolean ignorePasswordCase = false;

    @Override
    public String encodePassword(String rawPass, Object salt) {
        return this.mergePasswordAndSalt(rawPass, salt, true);
    }

    public boolean isIgnorePasswordCase() {
        return this.ignorePasswordCase;
    }

    @Override
    public boolean isPasswordValid(String encPass, String rawPass, Object salt) {
        String pass1 = encPass + "";
        String pass2 = this.mergePasswordAndSalt(rawPass, salt, false);
        if (this.ignorePasswordCase) {
            pass1 = pass1.toLowerCase(Locale.ENGLISH);
            pass2 = pass2.toLowerCase(Locale.ENGLISH);
        }
        return PasswordEncoderUtils.equals(pass1, pass2);
    }

    public String[] obtainPasswordAndSalt(String password) {
        return this.demergePasswordAndSalt(password);
    }

    public void setIgnorePasswordCase(boolean ignorePasswordCase) {
        this.ignorePasswordCase = ignorePasswordCase;
    }
}

