/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.support;

import java.util.List;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.rest.core.support.EntityLookup;
import org.springframework.data.rest.core.support.SelfLinkProvider;
import org.springframework.hateoas.EntityLinks;
import org.springframework.hateoas.Link;
import org.springframework.plugin.core.OrderAwarePluginRegistry;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.util.Assert;

public class DefaultSelfLinkProvider
implements SelfLinkProvider {
    private final PersistentEntities entities;
    private final EntityLinks entityLinks;
    private final PluginRegistry<EntityLookup<?>, Class<?>> lookups;

    public DefaultSelfLinkProvider(PersistentEntities entities, EntityLinks entityLinks, List<? extends EntityLookup<?>> lookups) {
        Assert.notNull((Object)entities, (String)"PersistentEntities must not be null!");
        Assert.notNull((Object)entityLinks, (String)"EntityLinks must not be null!");
        Assert.notNull(lookups, (String)"EntityLookups must not be null!");
        this.entities = entities;
        this.entityLinks = entityLinks;
        this.lookups = OrderAwarePluginRegistry.create(lookups);
    }

    @Override
    public Link createSelfLinkFor(Object instance) {
        Assert.notNull((Object)instance, (String)"Domain object must not be null!");
        return this.entityLinks.linkToSingleResource(instance.getClass(), this.getResourceId(instance));
    }

    private Object getResourceId(Object instance) {
        Class<?> instanceType = instance.getClass();
        EntityLookup lookup = (EntityLookup)this.lookups.getPluginFor(instanceType);
        if (lookup != null) {
            return lookup.getResourceIdentifier(instance);
        }
        PersistentEntity entity = this.entities.getPersistentEntity(instanceType);
        if (entity == null) {
            throw new IllegalArgumentException(String.format("Cannot create self link for %s! No persistent entity found!", instanceType));
        }
        return entity.getIdentifierAccessor(instance).getIdentifier();
    }
}

