/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.mapping;

import java.lang.reflect.Modifier;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.rest.core.Path;
import org.springframework.data.rest.core.annotation.Description;
import org.springframework.data.rest.core.annotation.RestResource;
import org.springframework.data.rest.core.mapping.AnnotationBasedResourceDescription;
import org.springframework.data.rest.core.mapping.CollectionResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceDescription;
import org.springframework.data.rest.core.mapping.SimpleResourceDescription;
import org.springframework.hateoas.RelProvider;
import org.springframework.hateoas.core.EvoInflectorRelProvider;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class TypeBasedCollectionResourceMapping
implements CollectionResourceMapping {
    private final Class<?> type;
    private final RelProvider relProvider;
    private final RestResource annotation;
    private final Description description;

    public TypeBasedCollectionResourceMapping(Class<?> type) {
        this(type, (RelProvider)new EvoInflectorRelProvider());
    }

    public TypeBasedCollectionResourceMapping(Class<?> type, RelProvider relProvider) {
        Assert.notNull(type, (String)"Type must not be null!");
        Assert.notNull((Object)relProvider, (String)"RelProvider must not be null!");
        this.type = type;
        this.relProvider = relProvider;
        this.annotation = (RestResource)AnnotationUtils.findAnnotation(type, RestResource.class);
        this.description = (Description)AnnotationUtils.findAnnotation(type, Description.class);
    }

    @Override
    public Path getPath() {
        String path = this.annotation == null ? null : this.annotation.path().trim();
        path = StringUtils.hasText((String)path) ? path : this.getDefaultPathFor(this.type);
        return new Path(path);
    }

    @Override
    public boolean isExported() {
        return this.annotation != null ? this.annotation.exported() : Modifier.isPublic(this.type.getModifiers());
    }

    @Override
    public String getRel() {
        if (this.annotation == null || !StringUtils.hasText((String)this.annotation.rel())) {
            return this.relProvider.getCollectionResourceRelFor(this.type);
        }
        return this.annotation.rel();
    }

    @Override
    public String getItemResourceRel() {
        return this.relProvider.getItemResourceRelFor(this.type);
    }

    @Override
    public boolean isPagingResource() {
        return false;
    }

    @Override
    public ResourceDescription getDescription() {
        ResourceDescription fallback = SimpleResourceDescription.defaultFor(this.getRel());
        if (this.description != null) {
            return new AnnotationBasedResourceDescription(this.description, fallback);
        }
        if (this.annotation != null) {
            return new AnnotationBasedResourceDescription(this.annotation.description(), fallback);
        }
        return fallback;
    }

    @Override
    public ResourceDescription getItemResourceDescription() {
        ResourceDescription fallback = SimpleResourceDescription.defaultFor(this.getItemResourceRel());
        if (this.annotation != null && StringUtils.hasText((String)this.annotation.description().value())) {
            return new AnnotationBasedResourceDescription(this.annotation.description(), fallback);
        }
        if (this.description != null) {
            return new AnnotationBasedResourceDescription(this.description, fallback);
        }
        return fallback;
    }

    @Override
    public Class<?> getExcerptProjection() {
        return null;
    }

    protected String getDefaultPathFor(Class<?> type) {
        return this.getSimpleTypeName(type);
    }

    private String getSimpleTypeName(Class<?> type) {
        return StringUtils.uncapitalize((String)type.getSimpleName());
    }
}

