/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.mapping;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.rest.core.Path;
import org.springframework.data.rest.core.annotation.RepositoryRestResource;
import org.springframework.data.rest.core.annotation.RestResource;
import org.springframework.data.rest.core.mapping.AnnotationBasedResourceDescription;
import org.springframework.data.rest.core.mapping.CollectionResourceMapping;
import org.springframework.data.rest.core.mapping.EvoInflectorTypeBasedCollectionResourceMapping;
import org.springframework.data.rest.core.mapping.RepositoryDetectionStrategy;
import org.springframework.data.rest.core.mapping.ResourceDescription;
import org.springframework.data.rest.core.mapping.SimpleResourceDescription;
import org.springframework.data.rest.core.mapping.TypeBasedCollectionResourceMapping;
import org.springframework.hateoas.RelProvider;
import org.springframework.hateoas.core.EvoInflectorRelProvider;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

class RepositoryCollectionResourceMapping
implements CollectionResourceMapping {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepositoryCollectionResourceMapping.class);
    private static final boolean EVO_INFLECTOR_IS_PRESENT = ClassUtils.isPresent((String)"org.atteo.evo.inflector.English", null);
    private final RestResource annotation;
    private final RepositoryRestResource repositoryAnnotation;
    private final CollectionResourceMapping domainTypeMapping;
    private final boolean repositoryExported;
    private final RepositoryMetadata metadata;

    public RepositoryCollectionResourceMapping(RepositoryMetadata metadata, RepositoryDetectionStrategy strategy) {
        this(metadata, (RelProvider)new EvoInflectorRelProvider(), strategy);
    }

    RepositoryCollectionResourceMapping(RepositoryMetadata metadata, RelProvider relProvider, RepositoryDetectionStrategy strategy) {
        Assert.notNull((Object)metadata, (String)"Repository metadata must not be null!");
        Assert.notNull((Object)relProvider, (String)"RelProvider must not be null!");
        Assert.notNull((Object)strategy, (String)"RepositoryDetectionStrategy must not be null!");
        Class repositoryType = metadata.getRepositoryInterface();
        this.metadata = metadata;
        this.annotation = (RestResource)AnnotationUtils.findAnnotation((Class)repositoryType, RestResource.class);
        this.repositoryAnnotation = (RepositoryRestResource)AnnotationUtils.findAnnotation((Class)repositoryType, RepositoryRestResource.class);
        this.repositoryExported = strategy.isExported(metadata);
        Class domainType = metadata.getDomainType();
        CollectionResourceMapping collectionResourceMapping = this.domainTypeMapping = EVO_INFLECTOR_IS_PRESENT ? new EvoInflectorTypeBasedCollectionResourceMapping(domainType, relProvider) : new TypeBasedCollectionResourceMapping(domainType, relProvider);
        if (this.annotation != null) {
            LOGGER.warn("@RestResource detected to customize the repository resource for {}! Use @RepositoryRestResource instead!", (Object)metadata.getRepositoryInterface().getName());
        }
    }

    @Override
    public Path getPath() {
        Path fallback = this.domainTypeMapping.getPath();
        if (this.repositoryAnnotation != null) {
            String path = this.repositoryAnnotation.path();
            return StringUtils.hasText((String)path) ? new Path(path) : fallback;
        }
        if (this.annotation != null) {
            String path = this.annotation.path();
            return StringUtils.hasText((String)path) ? new Path(path) : fallback;
        }
        return fallback;
    }

    @Override
    public String getRel() {
        String fallback = this.domainTypeMapping.getRel();
        if (this.repositoryAnnotation != null) {
            String rel = this.repositoryAnnotation.collectionResourceRel();
            return StringUtils.hasText((String)rel) ? rel : fallback;
        }
        if (this.annotation != null) {
            String rel = this.annotation.rel();
            return StringUtils.hasText((String)rel) ? rel : fallback;
        }
        return fallback;
    }

    @Override
    public String getItemResourceRel() {
        String fallback = this.domainTypeMapping.getItemResourceRel();
        if (this.repositoryAnnotation != null) {
            String rel = this.repositoryAnnotation.itemResourceRel();
            return StringUtils.hasText((String)rel) ? rel : fallback;
        }
        return fallback;
    }

    @Override
    public boolean isExported() {
        return this.repositoryExported;
    }

    @Override
    public boolean isPagingResource() {
        return this.metadata.isPagingRepository();
    }

    @Override
    public ResourceDescription getDescription() {
        ResourceDescription fallback = SimpleResourceDescription.defaultFor(this.getRel());
        if (this.repositoryAnnotation != null) {
            return new AnnotationBasedResourceDescription(this.repositoryAnnotation.collectionResourceDescription(), fallback);
        }
        return fallback;
    }

    @Override
    public ResourceDescription getItemResourceDescription() {
        ResourceDescription fallback = SimpleResourceDescription.defaultFor(this.getItemResourceRel());
        if (this.repositoryAnnotation != null) {
            return new AnnotationBasedResourceDescription(this.repositoryAnnotation.itemResourceDescription(), fallback);
        }
        return fallback;
    }

    @Override
    public Class<?> getExcerptProjection() {
        if (this.repositoryAnnotation == null) {
            return null;
        }
        Class<?> excerptProjection = this.repositoryAnnotation.excerptProjection();
        return excerptProjection.equals(RepositoryRestResource.None.class) ? null : excerptProjection;
    }
}

