/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.mapping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.SimpleAssociationHandler;
import org.springframework.data.mapping.SimplePropertyHandler;
import org.springframework.data.rest.core.annotation.RestResource;
import org.springframework.data.rest.core.mapping.MethodResourceMapping;
import org.springframework.data.rest.core.mapping.PersistentPropertyResourceMapping;
import org.springframework.data.rest.core.mapping.PropertyAwareResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.mapping.SearchResourceMappings;
import org.springframework.data.rest.core.mapping.SupportedHttpMethods;
import org.springframework.data.rest.core.mapping.TypeBasedCollectionResourceMapping;
import org.springframework.util.Assert;

class MappingResourceMetadata
extends TypeBasedCollectionResourceMapping
implements ResourceMetadata {
    private final PersistentEntity<?, ?> entity;
    private final PropertyMappings propertyMappings;
    private final boolean explicitlyExported;

    public MappingResourceMetadata(PersistentEntity<?, ?> entity, ResourceMappings resourceMappings) {
        super(entity.getType());
        this.propertyMappings = new PropertyMappings(resourceMappings);
        this.entity = entity;
        this.entity.doWithAssociations((SimpleAssociationHandler)this.propertyMappings);
        this.entity.doWithProperties((SimplePropertyHandler)this.propertyMappings);
        RestResource annotation = (RestResource)entity.findAnnotation(RestResource.class);
        this.explicitlyExported = annotation != null && annotation.exported();
    }

    @Override
    public Class<?> getDomainType() {
        return this.entity.getType();
    }

    @Override
    public boolean isExported(PersistentProperty<?> property) {
        return this.getMappingFor(property).isExported();
    }

    @Override
    public ResourceMapping getMappingFor(PersistentProperty<?> property) {
        return this.propertyMappings.getMappingFor(property);
    }

    @Override
    public SearchResourceMappings getSearchResourceMappings() {
        return new SearchResourceMappings(Collections.<MethodResourceMapping>emptyList());
    }

    @Override
    public SupportedHttpMethods getSupportedHttpMethods() {
        return SupportedHttpMethods.NoSupportedMethods.INSTANCE;
    }

    @Override
    public PropertyAwareResourceMapping getProperty(String mappedPath) {
        return this.propertyMappings.getMappingFor(mappedPath);
    }

    @Override
    public boolean isExported() {
        return this.explicitlyExported;
    }

    private static class PropertyMappings
    implements SimpleAssociationHandler,
    SimplePropertyHandler {
        private final ResourceMappings resourceMappings;
        private final Map<PersistentProperty<?>, PropertyAwareResourceMapping> propertyMappings;

        public PropertyMappings(ResourceMappings resourceMappings) {
            Assert.notNull((Object)resourceMappings, (String)"ResourceMappings must not be null!");
            this.resourceMappings = resourceMappings;
            this.propertyMappings = new HashMap();
        }

        public void doWithAssociation(Association<? extends PersistentProperty<?>> association) {
            this.doWithPersistentProperty(association.getInverse());
        }

        public void doWithPersistentProperty(PersistentProperty<?> property) {
            Assert.notNull(property, (String)"PersistentProperty must not be null!");
            this.propertyMappings.put(property, new PersistentPropertyResourceMapping(property, this.resourceMappings));
        }

        public PropertyAwareResourceMapping getMappingFor(String mappedPath) {
            Assert.hasText((String)mappedPath, (String)"Mapped path must not be null or empty!");
            for (PropertyAwareResourceMapping mapping : this.propertyMappings.values()) {
                if (!mapping.getPath().matches(mappedPath)) continue;
                return mapping;
            }
            return null;
        }

        public ResourceMapping getMappingFor(PersistentProperty<?> property) {
            return this.propertyMappings.get(property);
        }
    }
}

