/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.event;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationListener;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.rest.core.annotation.HandleAfterCreate;
import org.springframework.data.rest.core.annotation.HandleAfterDelete;
import org.springframework.data.rest.core.annotation.HandleAfterLinkDelete;
import org.springframework.data.rest.core.annotation.HandleAfterLinkSave;
import org.springframework.data.rest.core.annotation.HandleAfterSave;
import org.springframework.data.rest.core.annotation.HandleBeforeCreate;
import org.springframework.data.rest.core.annotation.HandleBeforeDelete;
import org.springframework.data.rest.core.annotation.HandleBeforeLinkDelete;
import org.springframework.data.rest.core.annotation.HandleBeforeLinkSave;
import org.springframework.data.rest.core.annotation.HandleBeforeSave;
import org.springframework.data.rest.core.annotation.RepositoryEventHandler;
import org.springframework.data.rest.core.event.AfterCreateEvent;
import org.springframework.data.rest.core.event.AfterDeleteEvent;
import org.springframework.data.rest.core.event.AfterLinkDeleteEvent;
import org.springframework.data.rest.core.event.AfterLinkSaveEvent;
import org.springframework.data.rest.core.event.AfterSaveEvent;
import org.springframework.data.rest.core.event.BeforeCreateEvent;
import org.springframework.data.rest.core.event.BeforeDeleteEvent;
import org.springframework.data.rest.core.event.BeforeLinkDeleteEvent;
import org.springframework.data.rest.core.event.BeforeLinkSaveEvent;
import org.springframework.data.rest.core.event.BeforeSaveEvent;
import org.springframework.data.rest.core.event.LinkedEntityEvent;
import org.springframework.data.rest.core.event.RepositoryEvent;
import org.springframework.data.rest.core.util.Methods;
import org.springframework.util.ClassUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;

public class AnnotatedEventHandlerInvoker
implements ApplicationListener<RepositoryEvent>,
BeanPostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotatedEventHandlerInvoker.class);
    private static final String PARAMETER_MISSING = "Invalid event handler method %s! At least a single argument is required to determine the domain type for which you are interested in events.";
    private final MultiValueMap<Class<? extends RepositoryEvent>, EventHandlerMethod> handlerMethods = new LinkedMultiValueMap();

    public void onApplicationEvent(RepositoryEvent event) {
        Class<?> eventType = ((Object)((Object)event)).getClass();
        if (!this.handlerMethods.containsKey(eventType)) {
            return;
        }
        for (EventHandlerMethod handlerMethod : (List)this.handlerMethods.get(eventType)) {
            Object src = event.getSource();
            if (!ClassUtils.isAssignable(handlerMethod.targetType, src.getClass())) continue;
            ArrayList<Object> parameters = new ArrayList<Object>();
            parameters.add(src);
            if (event instanceof LinkedEntityEvent) {
                parameters.add(((LinkedEntityEvent)event).getLinked());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Invoking {} handler for {}.", (Object)((Object)((Object)event)).getClass().getSimpleName(), event.getSource());
            }
            ReflectionUtils.invokeMethod((Method)handlerMethod.method, (Object)handlerMethod.handler, (Object[])parameters.toArray());
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(final Object bean, String beanName) throws BeansException {
        Class beanType = ClassUtils.getUserClass((Object)bean);
        RepositoryEventHandler typeAnno = (RepositoryEventHandler)AnnotationUtils.findAnnotation((Class)beanType, RepositoryEventHandler.class);
        if (typeAnno == null) {
            return bean;
        }
        ReflectionUtils.doWithMethods((Class)beanType, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                AnnotatedEventHandlerInvoker.this.inspect(bean, method, HandleBeforeCreate.class, BeforeCreateEvent.class);
                AnnotatedEventHandlerInvoker.this.inspect(bean, method, HandleAfterCreate.class, AfterCreateEvent.class);
                AnnotatedEventHandlerInvoker.this.inspect(bean, method, HandleBeforeSave.class, BeforeSaveEvent.class);
                AnnotatedEventHandlerInvoker.this.inspect(bean, method, HandleAfterSave.class, AfterSaveEvent.class);
                AnnotatedEventHandlerInvoker.this.inspect(bean, method, HandleBeforeLinkSave.class, BeforeLinkSaveEvent.class);
                AnnotatedEventHandlerInvoker.this.inspect(bean, method, HandleAfterLinkSave.class, AfterLinkSaveEvent.class);
                AnnotatedEventHandlerInvoker.this.inspect(bean, method, HandleBeforeDelete.class, BeforeDeleteEvent.class);
                AnnotatedEventHandlerInvoker.this.inspect(bean, method, HandleAfterDelete.class, AfterDeleteEvent.class);
                AnnotatedEventHandlerInvoker.this.inspect(bean, method, HandleBeforeLinkDelete.class, BeforeLinkDeleteEvent.class);
                AnnotatedEventHandlerInvoker.this.inspect(bean, method, HandleAfterLinkDelete.class, AfterLinkDeleteEvent.class);
            }
        }, (ReflectionUtils.MethodFilter)Methods.USER_METHODS);
        return bean;
    }

    private <T extends Annotation> void inspect(Object handler, Method method, Class<T> annotationType, Class<? extends RepositoryEvent> eventType) {
        Annotation annotation = AnnotationUtils.findAnnotation((Method)method, annotationType);
        if (annotation == null) {
            return;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length == 0) {
            throw new IllegalStateException(String.format(PARAMETER_MISSING, method));
        }
        EventHandlerMethod handlerMethod = new EventHandlerMethod(parameterTypes[0], handler, method);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Annotated handler method found: {}", (Object)handlerMethod);
        }
        this.handlerMethods.add(eventType, (Object)handlerMethod);
    }

    static class EventHandlerMethod {
        final Class<?> targetType;
        final Method method;
        final Object handler;

        private EventHandlerMethod(Class<?> targetType, Object handler, Method method) {
            this.targetType = targetType;
            this.method = method;
            this.handler = handler;
            ReflectionUtils.makeAccessible((Method)this.method);
        }

        public String toString() {
            return String.format("EventHandlerMethod{ targetType=%s, method=%s, handler=%s }", this.targetType, this.method, this.handler);
        }
    }
}

