/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.config;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.rest.core.config.Projection;
import org.springframework.data.rest.core.projection.ProjectionDefinitions;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class ProjectionDefinitionConfiguration
implements ProjectionDefinitions {
    private static final String PROJECTION_ANNOTATION_NOT_FOUND = "Projection annotation not found on %s! Either add the annotation or hand source type to the registration manually!";
    private static final String DEFAULT_PROJECTION_PARAMETER_NAME = "projection";
    private final Set<ProjectionDefinition> projectionDefinitions = new HashSet<ProjectionDefinition>();
    private String parameterName = "projection";

    @Override
    public String getParameterName() {
        return this.parameterName;
    }

    public void setParameterName(String parameterName) {
        this.parameterName = StringUtils.hasText((String)parameterName) ? parameterName : DEFAULT_PROJECTION_PARAMETER_NAME;
    }

    public ProjectionDefinitionConfiguration addProjection(Class<?> projectionType) {
        Assert.notNull(projectionType, (String)"Projection type must not be null!");
        Projection annotation = (Projection)AnnotationUtils.findAnnotation(projectionType, Projection.class);
        if (annotation == null) {
            throw new IllegalArgumentException(String.format(PROJECTION_ANNOTATION_NOT_FOUND, projectionType));
        }
        String name = annotation.name();
        Class<?>[] sourceTypes = annotation.types();
        return StringUtils.hasText((String)name) ? this.addProjection(projectionType, name, sourceTypes) : this.addProjection(projectionType, sourceTypes);
    }

    public ProjectionDefinitionConfiguration addProjection(Class<?> projectionType, Class<?> ... sourceTypes) {
        Assert.notNull(projectionType, (String)"Projection type must not be null!");
        return this.addProjection(projectionType, StringUtils.uncapitalize((String)projectionType.getSimpleName()), sourceTypes);
    }

    public ProjectionDefinitionConfiguration addProjection(Class<?> projectionType, String name, Class<?> ... sourceTypes) {
        Assert.notNull(projectionType, (String)"Projection type must not be null!");
        Assert.hasText((String)name, (String)"Name must not be null or empty!");
        Assert.notEmpty((Object[])sourceTypes, (String)"Source types must not be null!");
        for (Class<?> sourceType : sourceTypes) {
            this.projectionDefinitions.add(new ProjectionDefinition(sourceType, projectionType, name));
        }
        return this;
    }

    @Override
    public Class<?> getProjectionType(Class<?> sourceType, String name) {
        return this.getProjectionsFor(sourceType).get(name);
    }

    @Override
    public boolean hasProjectionFor(Class<?> sourceType) {
        for (ProjectionDefinition definition : this.projectionDefinitions) {
            if (!definition.sourceType.isAssignableFrom(sourceType)) continue;
            return true;
        }
        return false;
    }

    public Map<String, Class<?>> getProjectionsFor(Class<?> sourceType) {
        Assert.notNull(sourceType, (String)"Source type must not be null!");
        Class userType = ClassUtils.getUserClass(sourceType);
        HashMap<String, ProjectionDefinition> byName = new HashMap<String, ProjectionDefinition>();
        HashMap result = new HashMap();
        for (ProjectionDefinition entry : this.projectionDefinitions) {
            ProjectionDefinition existing;
            if (!entry.sourceType.isAssignableFrom(userType) || (existing = (ProjectionDefinition)byName.get(entry.name)) != null && !ProjectionDefinitionConfiguration.isSubTypeOf(entry.sourceType, existing.sourceType)) continue;
            byName.put(entry.name, entry);
            result.put(entry.name, entry.targetType);
        }
        return result;
    }

    private static boolean isSubTypeOf(Class<?> left, Class<?> right) {
        return right.isAssignableFrom(left) && !left.equals(right);
    }

    static final class ProjectionDefinition {
        private final Class<?> sourceType;
        private final Class<?> targetType;
        private final String name;

        public ProjectionDefinition(Class<?> sourceType, Class<?> targetType, String name) {
            Assert.notNull(sourceType, (String)"Source type must not be null!");
            Assert.notNull(targetType, (String)"Target type must not be null!");
            Assert.hasText((String)name, (String)"Name must not be null or empty!");
            this.sourceType = sourceType;
            this.targetType = targetType;
            this.name = name;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ProjectionDefinition)) {
                return false;
            }
            ProjectionDefinition that = (ProjectionDefinition)obj;
            return this.name.equals(that.name) && this.sourceType.equals(that.sourceType) && this.sourceType.equals(that.sourceType);
        }

        public int hashCode() {
            int result = 31;
            result += this.name.hashCode();
            result += this.sourceType.hashCode();
            return result += this.targetType.hashCode();
        }
    }
}

