/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.NonNull;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.model.PreferredConstructorDiscoverer;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.ProjectionInformation;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class ReturnedType {
    @NonNull
    private final Class<?> domainType;

    static ReturnedType of(Class<?> returnedType, Class<?> domainType, ProjectionFactory factory) {
        Assert.notNull(returnedType, (String)"Returned type must not be null!");
        Assert.notNull(domainType, (String)"Domain type must not be null!");
        Assert.notNull((Object)factory, (String)"ProjectionFactory must not be null!");
        return returnedType.isInterface() ? new ReturnedInterface(factory.getProjectionInformation(returnedType), domainType) : new ReturnedClass(returnedType, domainType);
    }

    public final Class<?> getDomainType() {
        return this.domainType;
    }

    public final boolean isInstance(Object source) {
        return this.getReturnedType().isInstance(source);
    }

    public abstract boolean isProjecting();

    public abstract Class<?> getReturnedType();

    public abstract boolean needsCustomConstruction();

    public abstract Class<?> getTypeToRead();

    public abstract List<String> getInputProperties();

    private ReturnedType(@NonNull Class<?> domainType) {
        if (domainType == null) {
            throw new IllegalArgumentException("domainType is null");
        }
        this.domainType = domainType;
    }

    private static final class ReturnedClass
    extends ReturnedType {
        private static final Set<Class<?>> VOID_TYPES = new HashSet<Class>(Arrays.asList(Void.class, Void.TYPE));
        private final Class<?> type;
        private final List<String> inputProperties;

        public ReturnedClass(Class<?> returnedType, Class<?> domainType) {
            super(domainType);
            Assert.notNull(returnedType, (String)"Returned type must not be null!");
            Assert.notNull(domainType, (String)"Domain type must not be null!");
            Assert.isTrue((!returnedType.isInterface() ? 1 : 0) != 0, (String)"Returned type must not be an interface!");
            this.type = returnedType;
            this.inputProperties = this.detectConstructorParameterNames(returnedType);
        }

        @Override
        public Class<?> getReturnedType() {
            return this.type;
        }

        @Override
        public Class<?> getTypeToRead() {
            return this.type;
        }

        @Override
        public boolean isProjecting() {
            return this.isDto();
        }

        @Override
        public boolean needsCustomConstruction() {
            return this.isDto() && !this.inputProperties.isEmpty();
        }

        @Override
        public List<String> getInputProperties() {
            return this.inputProperties;
        }

        private List<String> detectConstructorParameterNames(Class<?> type) {
            if (!this.isDto()) {
                return Collections.emptyList();
            }
            PreferredConstructorDiscoverer discoverer = new PreferredConstructorDiscoverer(type);
            PreferredConstructor constructor = discoverer.getConstructor();
            if (constructor == null) {
                return Collections.emptyList();
            }
            ArrayList<String> properties = new ArrayList<String>();
            for (PreferredConstructor.Parameter parameter : constructor.getParameters()) {
                properties.add(parameter.getName());
            }
            return properties;
        }

        private boolean isDto() {
            return !Object.class.equals(this.type) && !this.type.isEnum() && !this.isDomainSubtype() && !this.isPrimitiveOrWrapper() && !Number.class.isAssignableFrom(this.type) && !VOID_TYPES.contains(this.type) && !this.type.getPackage().getName().startsWith("java.");
        }

        private boolean isDomainSubtype() {
            return this.getDomainType().equals(this.type) && this.getDomainType().isAssignableFrom(this.type);
        }

        private boolean isPrimitiveOrWrapper() {
            return ClassUtils.isPrimitiveOrWrapper(this.type);
        }
    }

    private static final class ReturnedInterface
    extends ReturnedType {
        private final ProjectionInformation information;
        private final Class<?> domainType;

        public ReturnedInterface(ProjectionInformation information, Class<?> domainType) {
            super(domainType);
            Assert.notNull((Object)information, (String)"Projection information must not be null!");
            this.information = information;
            this.domainType = domainType;
        }

        @Override
        public Class<?> getReturnedType() {
            return this.information.getType();
        }

        @Override
        public boolean needsCustomConstruction() {
            return this.isProjecting() && this.information.isClosed();
        }

        @Override
        public boolean isProjecting() {
            return !this.information.getType().isAssignableFrom(this.domainType);
        }

        @Override
        public Class<?> getTypeToRead() {
            return this.isProjecting() && this.information.isClosed() ? null : this.domainType;
        }

        @Override
        public List<String> getInputProperties() {
            ArrayList<String> properties = new ArrayList<String>();
            for (PropertyDescriptor descriptor : this.information.getInputProperties()) {
                properties.add(descriptor.getName());
            }
            return properties;
        }
    }
}

