/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.querydsl.binding;

import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.PropertyReferenceException;
import org.springframework.data.querydsl.QueryDslUtils;
import org.springframework.data.querydsl.binding.MultiValueBinding;
import org.springframework.data.querydsl.binding.SingleValueBinding;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class QuerydslBindings {
    private final Map<String, PathAndBinding<?, ?>> pathSpecs = new LinkedHashMap();
    private final Map<Class<?>, PathAndBinding<?, ?>> typeSpecs = new LinkedHashMap();
    private final Set<String> whiteList = new HashSet<String>();
    private final Set<String> blackList = new HashSet<String>();
    private final Set<String> aliases = new HashSet<String>();
    private boolean excludeUnlistedProperties;

    public final <T extends Path<S>, S> AliasingPathBinder<T, S> bind(T path) {
        return new AliasingPathBinder(this, path);
    }

    public final <T extends Path<S>, S> PathBinder<T, S> bind(T ... paths) {
        return new PathBinder(this, paths);
    }

    public final <T> TypeBinder<T> bind(Class<T> type) {
        return new TypeBinder(type);
    }

    public final void excluding(Path<?> ... paths) {
        Assert.notEmpty((Object[])paths, (String)"At least one path has to be provided!");
        for (Path<?> path : paths) {
            this.blackList.add(QueryDslUtils.toDotPath(path));
        }
    }

    public final void including(Path<?> ... paths) {
        Assert.notEmpty((Object[])paths, (String)"At least one path has to be provided!");
        for (Path<?> path : paths) {
            this.whiteList.add(QueryDslUtils.toDotPath(path));
        }
    }

    public final QuerydslBindings excludeUnlistedProperties(boolean excludeUnlistedProperties) {
        this.excludeUnlistedProperties = excludeUnlistedProperties;
        return this;
    }

    boolean isPathAvailable(String path, Class<?> type) {
        Assert.notNull((Object)path, (String)"Path must not be null!");
        Assert.notNull(type, (String)"Type must not be null!");
        return this.isPathAvailable(path, ClassTypeInformation.from(type));
    }

    boolean isPathAvailable(String path, TypeInformation<?> type) {
        Assert.notNull((Object)path, (String)"Path must not be null!");
        Assert.notNull(type, (String)"Type must not be null!");
        return this.getPropertyPath(path, type) != null;
    }

    public <S extends Path<? extends T>, T> MultiValueBinding<S, T> getBindingForPath(PropertyPath path) {
        MultiValueBinding<?, ?> binding;
        Assert.notNull((Object)path, (String)"PropertyPath must not be null!");
        PathAndBinding<?, ?> pathAndBinding = this.pathSpecs.get(path.toDotPath());
        if (pathAndBinding != null && (binding = pathAndBinding.getBinding()) != null) {
            return pathAndBinding.getBinding();
        }
        pathAndBinding = this.typeSpecs.get(path.getLeafProperty().getType());
        return pathAndBinding == null ? null : pathAndBinding.getBinding();
    }

    Path<?> getExistingPath(PropertyPath path) {
        Assert.notNull((Object)path, (String)"PropertyPath must not be null!");
        PathAndBinding<?, ?> pathAndBuilder = this.pathSpecs.get(path.toDotPath());
        return pathAndBuilder == null ? null : pathAndBuilder.getPath();
    }

    PropertyPath getPropertyPath(String path, TypeInformation<?> type) {
        Assert.notNull((Object)path, (String)"Path must not be null!");
        if (!this.isPathVisible(path)) {
            return null;
        }
        if (this.pathSpecs.containsKey(path)) {
            return PropertyPath.from(QueryDslUtils.toDotPath(this.pathSpecs.get(path).getPath()), type);
        }
        try {
            PropertyPath propertyPath = PropertyPath.from(path, type);
            return this.isPathVisible(propertyPath) ? propertyPath : null;
        }
        catch (PropertyReferenceException o_O) {
            return null;
        }
    }

    private boolean isPathVisible(PropertyPath path) {
        List<String> segments = Arrays.asList(path.toDotPath().split("\\."));
        for (int i = 1; i <= segments.size(); ++i) {
            if (this.isPathVisible(StringUtils.collectionToDelimitedString(segments.subList(0, i), (String)"."))) continue;
            if (!this.whiteList.isEmpty()) {
                return this.whiteList.contains(path.toDotPath());
            }
            return false;
        }
        return true;
    }

    private boolean isPathVisible(String path) {
        if (this.aliases.contains(path) && !this.blackList.contains(path)) {
            return true;
        }
        if (this.whiteList.isEmpty()) {
            return this.excludeUnlistedProperties ? false : !this.blackList.contains(path);
        }
        return this.whiteList.contains(path);
    }

    static class MultiValueBindingAdapter<T extends Path<? extends S>, S>
    implements MultiValueBinding<T, S> {
        private final SingleValueBinding<T, S> delegate;

        public MultiValueBindingAdapter(SingleValueBinding<T, S> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Predicate bind(T path, Collection<? extends S> value) {
            Iterator<S> iterator = value.iterator();
            return this.delegate.bind(path, iterator.hasNext() ? (Object)iterator.next() : null);
        }
    }

    private static class PathAndBinding<S extends Path<? extends T>, T> {
        private final Path<?> path;
        private final MultiValueBinding<S, T> binding;

        public PathAndBinding(S path, MultiValueBinding<S, T> binding) {
            this.path = path;
            this.binding = binding;
        }

        public Path<?> getPath() {
            return this.path;
        }

        public MultiValueBinding<S, T> getBinding() {
            return this.binding;
        }
    }

    public final class TypeBinder<T> {
        private final Class<T> type;

        private TypeBinder(Class<T> type) {
            Assert.notNull(type, (String)"Type must not be null!");
            this.type = type;
        }

        public <P extends Path<T>> void first(SingleValueBinding<P, T> binding) {
            Assert.notNull(binding, (String)"Binding must not be null!");
            this.all(new MultiValueBindingAdapter<P, T>(binding));
        }

        public <P extends Path<T>> void all(MultiValueBinding<P, T> binding) {
            Assert.notNull(binding, (String)"Binding must not be null!");
            QuerydslBindings.this.typeSpecs.put(this.type, new PathAndBinding<Object, T>(null, binding));
        }
    }

    public static class AliasingPathBinder<P extends Path<? extends T>, T>
    extends PathBinder<P, T> {
        private final String alias;
        private final P path;
        final /* synthetic */ QuerydslBindings this$0;

        AliasingPathBinder(P path) {
            this(this$0, null, (Path)path);
        }

        private AliasingPathBinder(String alias, P path) {
            this.this$0 = this$0;
            super((QuerydslBindings)this$0, new Path[]{path});
            Assert.notNull(path, (String)"Path must not be null!");
            this.alias = alias;
            this.path = path;
        }

        public AliasingPathBinder<P, T> as(String alias) {
            Assert.hasText((String)alias, (String)"Alias must not be null or empty!");
            return new AliasingPathBinder(this.this$0, alias, this.path);
        }

        public void withDefaultBinding() {
            this.registerBinding(new PathAndBinding(this.path, null));
        }

        @Override
        protected void registerBinding(PathAndBinding<P, T> binding) {
            super.registerBinding(binding);
            if (this.alias != null) {
                this.this$0.pathSpecs.put(this.alias, binding);
                this.this$0.aliases.add(this.alias);
                this.this$0.blackList.add(QueryDslUtils.toDotPath(binding.getPath()));
            }
        }
    }

    public static class PathBinder<P extends Path<? extends T>, T> {
        private final List<P> paths;
        final /* synthetic */ QuerydslBindings this$0;

        PathBinder(P ... paths) {
            this.this$0 = this$0;
            Assert.notEmpty((Object[])paths, (String)"At least one path has to be provided!");
            this.paths = Arrays.asList(paths);
        }

        public void first(SingleValueBinding<P, T> binding) {
            Assert.notNull(binding, (String)"Binding must not be null!");
            this.all(new MultiValueBindingAdapter<P, T>(binding));
        }

        public void all(MultiValueBinding<P, T> binding) {
            Assert.notNull(binding, (String)"Binding must not be null!");
            for (Path path : this.paths) {
                this.registerBinding(new PathAndBinding<Path, T>(path, binding));
            }
        }

        protected void registerBinding(PathAndBinding<P, T> binding) {
            this.this$0.pathSpecs.put(QueryDslUtils.toDotPath(binding.getPath()), binding);
        }
    }
}

