/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.web.servlet;

import java.util.List;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.autoconfigure.web.servlet.MockMvcBuilderCustomizer;
import org.springframework.boot.test.autoconfigure.web.servlet.SpringBootMockMvcBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.MockMvcBuilder;
import org.springframework.test.web.servlet.setup.ConfigurableMockMvcBuilder;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@Configuration
@ConditionalOnWebApplication
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
@EnableConfigurationProperties
public class MockMvcAutoConfiguration {
    private final WebApplicationContext context;

    MockMvcAutoConfiguration(WebApplicationContext context) {
        this.context = context;
    }

    @Bean
    @ConditionalOnMissingBean(value={MockMvcBuilder.class})
    public DefaultMockMvcBuilder mockMvcBuilder(List<MockMvcBuilderCustomizer> customizers) {
        DefaultMockMvcBuilder builder = MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context);
        for (MockMvcBuilderCustomizer customizer : customizers) {
            customizer.customize((ConfigurableMockMvcBuilder<?>)builder);
        }
        return builder;
    }

    @Bean
    @ConfigurationProperties(value="spring.test.mockmvc")
    public SpringBootMockMvcBuilderCustomizer springBootMockMvcBuilderCustomizer() {
        return new SpringBootMockMvcBuilderCustomizer(this.context);
    }

    @Bean
    @ConditionalOnMissingBean
    public MockMvc mockMvc(MockMvcBuilder builder) {
        return builder.build();
    }
}

