/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.cache;

import org.springframework.boot.autoconfigure.cache.CacheConfigurations;
import org.springframework.boot.autoconfigure.cache.CacheType;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.AnnotationMetadata;

class CacheCondition
extends SpringBootCondition {
    CacheCondition() {
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)context.getEnvironment(), "spring.cache.");
        if (!resolver.containsProperty("type")) {
            return ConditionOutcome.match("Automatic cache type");
        }
        CacheType cacheType = CacheConfigurations.getType(((AnnotationMetadata)metadata).getClassName());
        String value = resolver.getProperty("type").replace("-", "_").toUpperCase();
        if (value.equals(cacheType.name())) {
            return ConditionOutcome.match("Cache type " + (Object)((Object)cacheType));
        }
        return ConditionOutcome.noMatch("Cache type " + value);
    }
}

