/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.maven.shared.model.DataSourceException;
import org.apache.maven.shared.model.DomainModel;
import org.apache.maven.shared.model.ImportModel;
import org.apache.maven.shared.model.InterpolatorProperty;
import org.apache.maven.shared.model.ModelContainer;
import org.apache.maven.shared.model.ModelContainerAction;
import org.apache.maven.shared.model.ModelContainerFactory;
import org.apache.maven.shared.model.ModelContainerInfo;
import org.apache.maven.shared.model.ModelDataSource;
import org.apache.maven.shared.model.ModelEventListener;
import org.apache.maven.shared.model.ModelProperty;
import org.apache.maven.shared.model.ModelPropertyTransformer;
import org.apache.maven.shared.model.ModelTransformer;
import org.apache.maven.shared.model.impl.DefaultModelDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelTransformerContext {
    private Collection<? extends ModelContainerInfo> infos;
    private static final List<InterpolatorProperty> systemInterpolatorProperties = new ArrayList<InterpolatorProperty>();
    private static final List<InterpolatorProperty> environmentInterpolatorProperties = new ArrayList<InterpolatorProperty>();

    protected ModelTransformerContext() {
        this(null);
    }

    public ModelTransformerContext(Collection<? extends ModelContainerInfo> infos) {
        this.infos = infos == null ? Collections.EMPTY_LIST : infos;
    }

    public static List<InterpolatorProperty> createInterpolatorProperties(List<ModelProperty> modelProperties, String baseUriForModel, Map<String, String> aliases, String interpolatorTag, boolean includeSystemProperties, boolean includeEnvironmentProperties) {
        if (modelProperties == null) {
            throw new IllegalArgumentException("modelProperties: null");
        }
        if (baseUriForModel == null) {
            throw new IllegalArgumentException("baseUriForModel: null");
        }
        ArrayList<InterpolatorProperty> interpolatorProperties = new ArrayList<InterpolatorProperty>();
        if (includeSystemProperties) {
            interpolatorProperties.addAll(systemInterpolatorProperties);
        }
        if (includeEnvironmentProperties) {
            interpolatorProperties.addAll(environmentInterpolatorProperties);
        }
        for (ModelProperty mp : modelProperties) {
            InterpolatorProperty ip = mp.asInterpolatorProperty(baseUriForModel);
            if (ip == null) continue;
            ip.setTag(interpolatorTag);
            interpolatorProperties.add(ip);
            for (Map.Entry<String, String> a : aliases.entrySet()) {
                interpolatorProperties.add(new InterpolatorProperty(ip.getKey().replaceAll(a.getKey(), a.getValue()), ip.getValue().replaceAll(a.getKey(), a.getValue()), interpolatorTag));
            }
        }
        ArrayList<InterpolatorProperty> ips = new ArrayList<InterpolatorProperty>();
        for (InterpolatorProperty ip : interpolatorProperties) {
            if (ips.contains(ip)) continue;
            ips.add(ip);
        }
        return ips;
    }

    public static void interpolateModelProperties(List<ModelProperty> modelProperties, List<InterpolatorProperty> interpolatorProperties) {
        if (modelProperties == null) {
            throw new IllegalArgumentException("modelProperties: null");
        }
        if (interpolatorProperties == null) {
            throw new IllegalArgumentException("interpolatorProperties: null");
        }
        ArrayList<ModelProperty> unresolvedProperties = new ArrayList<ModelProperty>();
        for (ModelProperty mp : modelProperties) {
            if (mp.isResolved()) continue;
            unresolvedProperties.add(mp);
        }
        LinkedHashSet<InterpolatorProperty> ips = new LinkedHashSet<InterpolatorProperty>();
        ips.addAll(interpolatorProperties);
        boolean continueInterpolation = true;
        while (continueInterpolation) {
            continueInterpolation = false;
            for (InterpolatorProperty ip : ips) {
                for (ModelProperty mp : unresolvedProperties) {
                    if (!mp.resolveWith(ip) || continueInterpolation) continue;
                    continueInterpolation = true;
                }
            }
        }
    }

    public static List<ModelProperty> transformModelProperties(List<ModelProperty> modelProperties, List<? extends ModelPropertyTransformer> modelPropertyTransformers) {
        if (modelProperties == null) {
            throw new IllegalArgumentException("modelProperties: null");
        }
        if (modelPropertyTransformers == null) {
            throw new IllegalArgumentException("modelPropertyTransformers: null");
        }
        List<ModelProperty> properties = new ArrayList<ModelProperty>(modelProperties);
        ArrayList<? extends ModelPropertyTransformer> transformers = new ArrayList<ModelPropertyTransformer>(modelPropertyTransformers);
        for (ModelPropertyTransformer modelPropertyTransformer : transformers) {
            properties = ModelTransformerContext.sort(modelPropertyTransformer.transform(ModelTransformerContext.sort(properties, modelPropertyTransformer.getBaseUri())), modelPropertyTransformer.getBaseUri());
            if (transformers.indexOf(modelPropertyTransformer) != transformers.size() - 1) continue;
            properties = ModelTransformerContext.sort(ModelTransformerContext.sort(properties, modelPropertyTransformer.getBaseUri()), modelPropertyTransformer.getBaseUri());
        }
        return properties;
    }

    public DomainModel transform(List<? extends DomainModel> domainModels, ModelTransformer fromModelTransformer, ModelTransformer toModelTransformer, Collection<? extends ImportModel> importModels, List<InterpolatorProperty> interpolatorProperties, List<? extends ModelEventListener> eventListeners) throws IOException {
        eventListeners = eventListeners == null ? new ArrayList<ModelEventListener>() : new ArrayList<ModelEventListener>(eventListeners);
        if (interpolatorProperties == null) {
            interpolatorProperties = new ArrayList<InterpolatorProperty>();
        }
        List<ModelProperty> transformedProperties = ModelTransformerContext.importModelProperties(importModels, fromModelTransformer.transformToModelProperties(domainModels));
        transformedProperties = fromModelTransformer.preprocessModelProperties(transformedProperties);
        String baseUriForModel = fromModelTransformer.getBaseUri();
        List<ModelProperty> modelProperties = ModelTransformerContext.sort(transformedProperties, baseUriForModel);
        modelProperties = ModelTransformerContext.determineLeafNodes(modelProperties);
        ArrayList<ModelContainerFactory> factories = new ArrayList<ModelContainerFactory>();
        for (ModelContainerInfo modelContainerInfo : this.infos) {
            factories.addAll(modelContainerInfo.getAllModelContainerFactories());
        }
        DefaultModelDataSource modelDataSource = new DefaultModelDataSource(modelProperties, factories);
        for (ModelContainerInfo modelContainerInfo : this.infos) {
            this.processContainers(modelDataSource, null, modelContainerInfo);
        }
        List<ModelProperty> list2 = modelDataSource.getModelProperties();
        list2 = ModelTransformerContext.sort(list2, baseUriForModel);
        fromModelTransformer.interpolateModelProperties(list2, interpolatorProperties, domainModels.get(0));
        try {
            DomainModel domainModel = toModelTransformer.transformToDomainModel(list2, eventListeners);
            domainModel.setEventHistory(modelDataSource.getEventHistory());
            return domainModel;
        }
        catch (IOException iOException) {
            System.out.println(modelDataSource.getEventHistory());
            iOException.printStackTrace();
            throw new IOException(iOException.getMessage());
        }
    }

    private void processChildContainers(ModelDataSource modelDataSource, ModelDataSource childModelDataSource, ModelContainerInfo info) throws IOException {
        ModelContainerFactory factory = info.getModelContainerFactory();
        for (String uri : factory.getUris()) {
            List<ModelContainer> modelContainers;
            try {
                modelContainers = childModelDataSource.queryFor(uri);
            }
            catch (IllegalArgumentException e) {
                System.out.println(modelDataSource.getEventHistory());
                throw new IllegalArgumentException(e);
            }
            ArrayList<ModelContainer> removedModelContainers = new ArrayList<ModelContainer>();
            Collections.reverse(modelContainers);
            for (int i = 0; i < modelContainers.size(); ++i) {
                ModelContainer mcA = modelContainers.get(i);
                if (removedModelContainers.contains(mcA)) continue;
                for (ModelContainer mcB : modelContainers.subList(i + 1, modelContainers.size())) {
                    ModelContainerAction action = mcA.containerAction(mcB);
                    if (ModelContainerAction.DELETE.equals((Object)action)) {
                        modelDataSource.delete(mcB);
                        removedModelContainers.add(mcB);
                        continue;
                    }
                    if (!ModelContainerAction.JOIN.equals((Object)action)) continue;
                    try {
                        mcA = modelDataSource.join(mcA, mcB);
                        removedModelContainers.add(mcB);
                        if (info.getChildren() == null) continue;
                        for (ModelContainerInfo child : info.getChildren()) {
                            DefaultModelDataSource childDataSource = new DefaultModelDataSource(mcA.getProperties(), child.getAllModelContainerFactories());
                            this.processChildContainers(modelDataSource, childDataSource, child);
                            if (child.getModelContainerRule() == null) continue;
                            mcA = modelDataSource.replace(mcA, mcA.createNewInstance(child.getModelContainerRule().execute(childDataSource.getModelProperties())));
                        }
                    }
                    catch (DataSourceException e) {
                        System.out.println(modelDataSource.getEventHistory());
                        e.printStackTrace();
                        throw new IOException("Failed to join model containers: URI = " + uri + ", Factory = " + factory.getClass().getName());
                    }
                }
            }
        }
    }

    private void processContainers(ModelDataSource modelDataSource, ModelDataSource childModelDataSource, ModelContainerInfo info) throws IOException {
        ModelContainerFactory factory = info.getModelContainerFactory();
        for (String uri : factory.getUris()) {
            List<ModelContainer> modelContainers;
            try {
                modelContainers = modelDataSource.queryFor(uri);
            }
            catch (IllegalArgumentException e) {
                System.out.println(modelDataSource.getEventHistory());
                throw new IllegalArgumentException(e);
            }
            ArrayList<ModelContainer> removedModelContainers = new ArrayList<ModelContainer>();
            Collections.reverse(modelContainers);
            for (int i = 0; i < modelContainers.size(); ++i) {
                ModelContainer mcA = modelContainers.get(i);
                if (removedModelContainers.contains(mcA)) continue;
                for (ModelContainer mcB : modelContainers.subList(i + 1, modelContainers.size())) {
                    ModelContainerAction action = mcA.containerAction(mcB);
                    if (ModelContainerAction.DELETE.equals((Object)action)) {
                        modelDataSource.delete(mcB);
                        removedModelContainers.add(mcB);
                        continue;
                    }
                    if (!ModelContainerAction.JOIN.equals((Object)action)) continue;
                    try {
                        mcA = modelDataSource.join(mcA, mcB);
                        removedModelContainers.add(mcB);
                        if (info.getChildren() == null) continue;
                        for (ModelContainerInfo child : info.getChildren()) {
                            DefaultModelDataSource childDataSource = new DefaultModelDataSource(mcA.getProperties(), child.getAllModelContainerFactories());
                            this.processChildContainers(modelDataSource, childDataSource, child);
                        }
                    }
                    catch (DataSourceException e) {
                        System.out.println(modelDataSource.getEventHistory());
                        e.printStackTrace();
                        throw new IOException("Failed to join model containers: URI = " + uri + ", Factory = " + factory.getClass().getName());
                    }
                }
            }
        }
    }

    public DomainModel transform(List<? extends DomainModel> domainModels, ModelTransformer fromModelTransformer, ModelTransformer toModelTransformer) throws IOException {
        return this.transform(domainModels, fromModelTransformer, toModelTransformer, null, systemInterpolatorProperties, null);
    }

    private static List<ModelProperty> importModelProperties(Collection<? extends ImportModel> importModels, List<ModelProperty> modelProperties) {
        ArrayList<ModelProperty> properties = new ArrayList<ModelProperty>();
        for (ModelProperty mp : modelProperties) {
            if (mp.getUri().endsWith("importModel")) {
                for (ImportModel importModel : importModels) {
                    if (!importModel.getId().equals(mp.getResolvedValue())) continue;
                    properties.addAll(importModel.getModelProperties());
                }
                continue;
            }
            properties.add(mp);
        }
        return properties;
    }

    public static List<ModelProperty> sort(List<ModelProperty> properties, String baseUri) {
        if (properties == null) {
            throw new IllegalArgumentException("properties");
        }
        LinkedList<ModelProperty> processedProperties = new LinkedList<ModelProperty>();
        ArrayList<String> position = new ArrayList<String>();
        boolean projectIsContained = false;
        for (ModelProperty p : properties) {
            int pst;
            String uri = p.getUri();
            String parentUri = uri.substring(0, uri.lastIndexOf("/"));
            if (!projectIsContained && uri.equals(baseUri)) {
                projectIsContained = true;
                processedProperties.add(p);
                position.add(0, uri);
                continue;
            }
            if (position.contains(uri) && !parentUri.contains("#collection") && !parentUri.contains("#set")) continue;
            int n = pst = parentUri.endsWith("#property") ? position.indexOf(parentUri.replaceAll("#property", "")) + 1 : position.indexOf(parentUri) + 1;
            if (pst == 0 && !uri.equals(properties.get(0).getUri())) {
                for (ModelProperty mp : properties) {
                    System.out.println(mp);
                }
                throw new IllegalArgumentException("Could not locate parent: Parent URI = " + parentUri + ": Child - " + p.toString());
            }
            processedProperties.add(pst, p);
            position.add(pst, uri);
        }
        return processedProperties;
    }

    private static List<ModelProperty> determineLeafNodes(List<ModelProperty> modelProperties) {
        ArrayList<ModelProperty> mps = new ArrayList<ModelProperty>();
        for (ModelProperty mp : modelProperties) {
            if (mp.getResolvedValue() != null && mp.getResolvedValue().trim().equals("") && ModelTransformerContext.isLeafNode(mp, modelProperties)) {
                mps.add(new ModelProperty(mp.getUri(), null));
                continue;
            }
            mps.add(mp);
        }
        return mps;
    }

    private static boolean isLeafNode(ModelProperty modelProperty, List<ModelProperty> modelProperties) {
        for (int i = modelProperties.indexOf(modelProperty); i < modelProperties.size() - 1; ++i) {
            ModelProperty peekProperty = modelProperties.get(i + 1);
            if (modelProperty.isParentOf(peekProperty) && !peekProperty.getUri().contains("#property")) {
                return true;
            }
            if (modelProperty.isParentOf(peekProperty)) continue;
            return modelProperty.getDepth() < peekProperty.getDepth();
        }
        return true;
    }

    static {
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            systemInterpolatorProperties.add(new InterpolatorProperty("${" + entry.getKey() + "}", (String)entry.getValue()));
        }
        for (Map.Entry<Object, Object> entry : System.getenv().entrySet()) {
            environmentInterpolatorProperties.add(new InterpolatorProperty("${env." + (String)entry.getKey() + "}", (String)entry.getValue()));
        }
    }
}

