/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.model;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.maven.shared.model.ModelContainerFactory;
import org.apache.maven.shared.model.ModelContainerRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ModelContainerInfo {
    public ModelContainerFactory getModelContainerFactory();

    public ModelContainerRule getModelContainerRule();

    public Collection<ModelContainerInfo> getChildren();

    public Collection<ModelContainerFactory> getAllModelContainerFactories();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory {
        public static ModelContainerInfo createModelContainerInfo(final ModelContainerFactory factory, final ModelContainerRule rule, final Collection<ModelContainerInfo> children) {
            return new ModelContainerInfo(){
                private Collection<ModelContainerFactory> factories;

                @Override
                public ModelContainerFactory getModelContainerFactory() {
                    return factory;
                }

                @Override
                public ModelContainerRule getModelContainerRule() {
                    return rule;
                }

                @Override
                public Collection<ModelContainerInfo> getChildren() {
                    return children;
                }

                @Override
                public Collection<ModelContainerFactory> getAllModelContainerFactories() {
                    if (this.factories == null) {
                        this.factories = new ArrayList<ModelContainerFactory>();
                        this.factories.add(factory);
                        if (children != null) {
                            for (ModelContainerInfo info : children) {
                                this.factories.addAll(info.getAllModelContainerFactories());
                            }
                        }
                    }
                    return this.factories;
                }
            };
        }
    }
}

