/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.gshell.io;

import java.io.InputStream;
import java.io.OutputStream;
import org.sonatype.gshell.io.Closer;
import org.sonatype.gshell.io.StreamPumper;
import org.sonatype.gshell.io.StreamSet;

public class PumpStreamHandler {
    private final StreamSet streams;
    private Thread outputThread;
    private Thread errorThread;
    private StreamPumper inputPump;

    public PumpStreamHandler(StreamSet streams) {
        assert (streams != null);
        this.streams = streams;
    }

    public void setChildOutputStream(InputStream in) {
        assert (in != null);
        this.createChildOutputPump(in, this.streams.out);
    }

    public void setChildErrorStream(InputStream in) {
        assert (in != null);
        if (this.streams.err != null) {
            this.createChildErrorPump(in, this.streams.err);
        }
    }

    public void setChildInputStream(OutputStream out) {
        assert (out != null);
        if (this.streams.in != null) {
            this.inputPump = this.createInputPump(this.streams.in, out, true);
        } else {
            Closer.close(out);
        }
    }

    public void attach(Process p) {
        assert (p != null);
        this.setChildInputStream(p.getOutputStream());
        this.setChildOutputStream(p.getInputStream());
        this.setChildErrorStream(p.getErrorStream());
    }

    public void start() {
        if (this.outputThread != null) {
            this.outputThread.start();
        }
        if (this.errorThread != null) {
            this.errorThread.start();
        }
        if (this.inputPump != null) {
            Thread inputThread = new Thread(this.inputPump);
            inputThread.setDaemon(true);
            inputThread.start();
        }
    }

    public void stop() {
        if (this.outputThread != null) {
            try {
                this.outputThread.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (this.errorThread != null) {
            try {
                this.errorThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.inputPump != null) {
            this.inputPump.stop();
        }
        this.streams.flush();
    }

    protected void createChildOutputPump(InputStream in, OutputStream out) {
        assert (in != null);
        assert (out != null);
        this.outputThread = this.createPump(in, out);
    }

    protected void createChildErrorPump(InputStream in, OutputStream out) {
        assert (in != null);
        assert (out != null);
        this.errorThread = this.createPump(in, out);
    }

    protected Thread createPump(InputStream in, OutputStream out) {
        assert (in != null);
        assert (out != null);
        return this.createPump(in, out, false);
    }

    protected Thread createPump(InputStream in, OutputStream out, boolean closeWhenExhausted) {
        assert (in != null);
        assert (out != null);
        Thread result = new Thread(new StreamPumper(in, out, closeWhenExhausted));
        result.setDaemon(true);
        return result;
    }

    protected StreamPumper createInputPump(InputStream in, OutputStream out, boolean closeWhenExhausted) {
        assert (in != null);
        assert (out != null);
        StreamPumper pumper = new StreamPumper(in, out, closeWhenExhausted);
        pumper.setAutoFlush(true);
        return pumper;
    }
}

