/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.gshell.io;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import jline.Terminal;
import jline.console.ConsoleReader;
import org.sonatype.gshell.io.StreamSet;

public class PromptReader {
    private char mask = (char)42;
    private final ConsoleReader reader;

    public PromptReader(StreamSet streams, Terminal term) throws IOException {
        assert (streams != null);
        assert (term != null);
        this.reader = this.createReader(streams, term);
    }

    protected ConsoleReader createReader(StreamSet streams, Terminal term) throws IOException {
        assert (streams != null);
        assert (term != null);
        return new ConsoleReader(streams.in, (Writer)new PrintWriter(streams.out, true), term);
    }

    public char getMask() {
        return this.mask;
    }

    public void setMask(char mask) {
        this.mask = mask;
    }

    public String readLine(String prompt, Validator validator) throws IOException {
        String value;
        assert (prompt != null);
        do {
            value = this.reader.readLine(prompt);
        } while (validator != null && !validator.isValid(value));
        return value;
    }

    public String readLine(String prompt) throws IOException {
        return this.readLine(prompt, null);
    }

    public String readLine(String prompt, char mask, Validator validator) throws IOException {
        String value;
        assert (prompt != null);
        do {
            value = this.reader.readLine(prompt, Character.valueOf(mask));
        } while (validator != null && !validator.isValid(value));
        return value;
    }

    public String readLine(String prompt, char mask) throws IOException {
        return this.readLine(prompt, mask, null);
    }

    public String readPassword(String prompt, Validator validator) throws IOException {
        String value;
        assert (prompt != null);
        do {
            value = this.reader.readLine(prompt, Character.valueOf(this.mask));
        } while (validator != null && !validator.isValid(value));
        return value;
    }

    public String readPassword(String prompt) throws IOException {
        return this.readPassword(prompt, null);
    }

    public static interface Validator {
        public boolean isValid(String var1);
    }
}

