/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.gshell.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import jline.Terminal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.gshell.io.StreamSet;

public class InputPipe
extends Thread
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(InputPipe.class);
    private final BlockingQueue<Integer> queue = new ArrayBlockingQueue<Integer>(1024);
    private final Terminal term;
    private final StreamSet streams;
    private final InterruptHandler interruptHandler;
    private final CountDownLatch startSignal = new CountDownLatch(1);
    private volatile boolean interrupt;
    private volatile boolean running;

    public InputPipe(StreamSet streams, Terminal terminal, InterruptHandler interruptHandler) {
        assert (streams != null);
        this.streams = streams;
        this.term = terminal;
        assert (interruptHandler != null);
        this.interruptHandler = interruptHandler;
    }

    public void close() {
        if (this.running) {
            log.trace("Closing");
            Thread.currentThread().interrupt();
            this.running = false;
        }
    }

    private int read() throws IOException {
        return this.term.readCharacter(this.streams.in);
    }

    public void start() {
        super.start();
        try {
            this.startSignal.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        log.trace("Running");
        this.running = true;
        try {
            this.startSignal.countDown();
            while (this.running) {
                try {
                    int c = this.read();
                    switch (c) {
                        case -1: {
                            this.queue.put(c);
                            return;
                        }
                        case 3: {
                            this.interrupt = this.interruptHandler.interrupt();
                            break;
                        }
                    }
                    this.queue.put(c);
                }
                catch (IOException e) {
                    log.warn("Pipe read error", (Throwable)e);
                    this.term.restore();
                    this.term.init();
                }
            }
        }
        catch (Throwable t) {
            log.error("Pipe read failure", t);
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (!(t instanceof Error)) throw new Error(t);
            throw (Error)t;
        }
        finally {
            this.close();
        }
        log.trace("Stopped");
    }

    public InputStream getInputStream() {
        return new PipeInputStream();
    }

    private class PipeInputStream
    extends InputStream {
        private PipeInputStream() {
        }

        private void checkInterrupted() throws InterruptedIOException {
            if (InputPipe.this.interrupt) {
                InputPipe.this.interrupt = false;
                throw new InterruptedIOException("Keyboard interruption");
            }
        }

        private int read(boolean wait) throws IOException {
            Integer i;
            if (!InputPipe.this.running) {
                return -1;
            }
            this.checkInterrupted();
            if (wait) {
                try {
                    InputPipe.this.startSignal.await();
                    i = (Integer)InputPipe.this.queue.take();
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
                this.checkInterrupted();
            } else {
                i = (Integer)InputPipe.this.queue.poll();
            }
            if (i == null) {
                return -1;
            }
            return i;
        }

        public int read() throws IOException {
            return this.read(true);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int nb;
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int i = this.read(true);
            if (i < 0) {
                return -1;
            }
            b[off++] = (byte)i;
            for (nb = 1; nb < len; ++nb) {
                i = this.read(false);
                if (i < 0) {
                    return nb;
                }
                b[off++] = (byte)i;
            }
            return nb;
        }
    }

    public static interface InterruptHandler {
        public boolean interrupt() throws Exception;

        public boolean stop() throws Exception;
    }
}

