/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.apache.maven.plugin.logging.Log;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.simplify4u.plugins.PGPKeysServerClient;
import org.simplify4u.plugins.PGPServerRetryHandler;

public class PGPKeysCache {
    private final Log log;
    private final File cachePath;
    private final PGPKeysServerClient keysServerClient;

    public PGPKeysCache(Log log, File cachePath, String keyServer) throws URISyntaxException, CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, KeyManagementException {
        this.log = log;
        this.cachePath = cachePath;
        this.keysServerClient = PGPKeysServerClient.getClient(keyServer);
    }

    String getUrlForShowKey(long keyID) {
        return this.keysServerClient.getUriForShowKey(keyID).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PGPPublicKey getKey(long keyID) throws IOException, PGPException {
        File keyFile = null;
        PGPPublicKey key = null;
        try {
            InputStream keyIn;
            PGPPublicKeyRingCollection pgpRing;
            String path = String.format("%02X/%02X/%016X.asc", (byte)(keyID >> 56), (byte)(keyID >> 48 & 0xFFL), keyID);
            keyFile = new File(this.cachePath, path);
            if (!keyFile.exists()) {
                this.receiveKey(keyFile, keyID);
            }
            if ((key = (pgpRing = new PGPPublicKeyRingCollection(keyIn = PGPUtil.getDecoderStream((InputStream)new FileInputStream(keyFile)), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator())).getPublicKey(keyID)) == null) {
                this.deleteFile(keyFile);
            }
        }
        catch (Throwable throwable) {
            if (key == null) {
                this.deleteFile(keyFile);
            }
            throw throwable;
        }
        return key;
    }

    private void receiveKey(File keyFile, long keyId) throws IOException {
        File dir = keyFile.getParentFile();
        if (dir == null) {
            throw new IOException("No parent dir for: " + keyFile);
        }
        if (dir.exists() && !dir.isDirectory()) {
            throw new IOException("Path exist but it isn't directory: " + dir);
        }
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Can't create directory: " + dir);
        }
        try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(keyFile));){
            this.keysServerClient.copyKeyToOutputStream(keyId, outputStream, new PGPServerRetryHandler(this.log));
        }
        catch (IOException e) {
            this.deleteFile(keyFile);
            throw e;
        }
        this.log.info((CharSequence)String.format("Receive key: %s\n\tto %s", this.keysServerClient.getUriForGetKey(keyId), keyFile));
    }

    private void deleteFile(File keyFile) {
        if (keyFile == null || !keyFile.exists()) {
            return;
        }
        if (!keyFile.delete()) {
            this.log.warn((CharSequence)("Can't delete: " + keyFile));
        }
    }
}

