/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins;

import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.simplify4u.plugins.ArtifactInfo;
import org.simplify4u.plugins.KeyInfo;

@Component(role=KeysMap.class)
public class KeysMap {
    @Requirement
    private ResourceManager resourceManager;
    private final List<ArtifactInfo> keysMapList = new ArrayList<ArtifactInfo>();

    public void load(String locale) throws ResourceNotFoundException, IOException {
        if (!Strings.isNullOrEmpty((String)locale) && !Strings.isNullOrEmpty((String)locale.trim())) {
            Map<String, String> propertyMap;
            try (InputStream inputStream = this.resourceManager.getResourceAsInputStream(locale);){
                propertyMap = this.loadKeysMap(inputStream);
            }
            this.processKeysMap(propertyMap);
        }
    }

    public boolean isValidKey(Artifact artifact, PGPPublicKey key) {
        if (this.keysMapList.isEmpty()) {
            return true;
        }
        for (ArtifactInfo artifactInfo : this.keysMapList) {
            if (!artifactInfo.isMatch(artifact)) continue;
            return artifactInfo.isKeyMatch(key);
        }
        return false;
    }

    private Map<String, String> loadKeysMap(InputStream inputStream) throws IOException {
        String currentLine;
        LinkedHashMap<String, String> keysMaps = new LinkedHashMap<String, String>();
        BufferedReader mapReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((currentLine = mapReader.readLine()) != null) {
            if (currentLine.isEmpty() || this.isCommentLine(currentLine)) continue;
            String[] parts = currentLine.split("=");
            if (parts.length != 2) {
                throw new IllegalArgumentException("Property line is malformed: " + currentLine);
            }
            keysMaps.put(parts[0], parts[1]);
        }
        return keysMaps;
    }

    private void processKeysMap(Map<String, String> keysMap) {
        for (Map.Entry<String, String> mapEntry : keysMap.entrySet()) {
            ArtifactInfo artifactInfo = this.createArtifactInfo(mapEntry.getKey(), mapEntry.getValue());
            this.keysMapList.add(artifactInfo);
        }
    }

    private boolean isCommentLine(String line) {
        return !line.isEmpty() && line.charAt(0) == '#';
    }

    private ArtifactInfo createArtifactInfo(String strArtifact, String strKeys) {
        return new ArtifactInfo(strArtifact, new KeyInfo(strKeys));
    }
}

