/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle.openpgp.PGPPublicKey;

public class KeyInfo {
    private final boolean matchAny;
    private final List<byte[]> keysID = new ArrayList<byte[]>();

    public KeyInfo(String strKeys) {
        if ("*".equals(strKeys) || "any".equalsIgnoreCase(strKeys)) {
            this.matchAny = true;
            return;
        }
        this.matchAny = false;
        if (strKeys == null) {
            throw new IllegalArgumentException("null key not allowed");
        }
        for (String key : strKeys.split(",")) {
            if (!(key = key.trim()).startsWith("0x")) {
                throw new IllegalArgumentException("Invalid keyID " + key + " must start with 0x");
            }
            byte[] bytes = this.strKeyToBytes(key.substring(2));
            this.keysID.add(bytes);
        }
    }

    private byte[] strKeyToBytes(String key) {
        BigInteger bigInteger = new BigInteger(key, 16);
        if (bigInteger.bitLength() < 32 || bigInteger.bitLength() > 160) {
            throw new IllegalArgumentException("Invalid key length key=" + key);
        }
        byte[] bytes = bigInteger.toByteArray();
        if (bytes[0] == 0 && bytes.length % 2 != 0) {
            bytes = Arrays.copyOfRange(bytes, 1, bytes.length);
        }
        return bytes;
    }

    public boolean isKeyMatch(PGPPublicKey pgpPublicKeyey) {
        if (this.matchAny) {
            return true;
        }
        byte[] fingerprint = pgpPublicKeyey.getFingerprint();
        for (byte[] keyBytes : this.keysID) {
            if (!this.compareArrays(keyBytes, fingerprint)) continue;
            return true;
        }
        return false;
    }

    private boolean compareArrays(byte[] keyBytes, byte[] fingerprint) {
        for (int i = 1; i <= keyBytes.length && i <= fingerprint.length; ++i) {
            if (keyBytes[keyBytes.length - i] == fingerprint[fingerprint.length - i]) continue;
            return false;
        }
        return true;
    }
}

