/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.richfaces.component.AbstractDropDownMenu;
import org.richfaces.component.AbstractMenuGroup;
import org.richfaces.renderkit.RendererBase;

public abstract class MenuGroupRendererBase
extends RendererBase {
    public static final String RENDERER_TYPE = "org.richfaces.MenuGroupRenderer";
    public static final int DEFAULT_MIN_POPUP_WIDTH = 250;

    protected boolean isDisabled(FacesContext facesContext, UIComponent component) {
        if (component instanceof AbstractMenuGroup) {
            return ((AbstractMenuGroup)component).isDisabled();
        }
        return false;
    }

    @Override
    public void renderChildren(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractMenuGroup menuGroup = (AbstractMenuGroup)component;
        for (UIComponent child : menuGroup.getChildren()) {
            if (!child.isRendered()) continue;
            child.encodeAll(facesContext);
        }
    }

    protected UIComponent getIconFacet(FacesContext facesContext, UIComponent component) {
        UIComponent facet = null;
        AbstractMenuGroup menuGroup = (AbstractMenuGroup)component;
        if (menuGroup != null) {
            facet = menuGroup.isDisabled() ? menuGroup.getFacet(AbstractMenuGroup.Facets.iconDisabled.toString()) : menuGroup.getFacet(AbstractMenuGroup.Facets.icon.toString());
        }
        return facet;
    }

    protected String getIconAttribute(FacesContext facesContext, UIComponent component) {
        String icon = null;
        AbstractMenuGroup menuGroup = (AbstractMenuGroup)component;
        if (menuGroup != null) {
            icon = menuGroup.isDisabled() ? menuGroup.getIconDisabled() : menuGroup.getIcon();
        }
        return icon;
    }

    protected String getStyleClass(FacesContext facesContext, UIComponent component, String styleDDMenu, String styleMenuGroup) {
        UIComponent ddMenu = this.getDDMenu(facesContext, component);
        String styleClass = "";
        if (ddMenu != null && ddMenu.getAttributes().get(styleDDMenu) != null) {
            styleClass = ddMenu.getAttributes().get(styleDDMenu).toString();
        }
        return this.concatClasses(styleClass, component.getAttributes().get(styleMenuGroup));
    }

    protected UIComponent getDDMenu(FacesContext facesContext, UIComponent component) {
        for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof AbstractDropDownMenu)) continue;
            return parent;
        }
        return null;
    }

    protected int getMinPopupWidth(FacesContext facesContext, UIComponent component) {
        UIComponent parent = this.getDDMenu(facesContext, component);
        int width = 0;
        if (parent != null && (width = ((AbstractDropDownMenu)parent).getPopupWidth()) <= 0) {
            width = 250;
        }
        return width;
    }

    protected boolean isStringEmpty(String str) {
        return str == null || str.trim().length() <= 0;
    }
}

