/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.common;

import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.Iterator;
import org.openqa.selenium.Point;

public class Locations
implements Iterable<Point> {
    private final Point topLeft;
    private final Point topRight;
    private final Point bottomLeft;
    private final Point bottomRight;

    public Locations(Point topLeft, Point topRight, Point bottomLeft, Point bottomRight) {
        this.topLeft = topLeft;
        this.topRight = topRight;
        this.bottomLeft = bottomLeft;
        this.bottomRight = bottomRight;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Locations other = (Locations)obj;
        if (!this.topLeft.equals((Object)other.topLeft)) {
            return false;
        }
        if (!this.topRight.equals((Object)other.topRight)) {
            return false;
        }
        if (!this.bottomLeft.equals((Object)other.bottomLeft)) {
            return false;
        }
        return this.bottomRight.equals((Object)other.bottomRight);
    }

    public Point getBottomLeft() {
        return this.bottomLeft;
    }

    public Point getBottomRight() {
        return this.bottomRight;
    }

    public int getHeight() {
        return this.bottomRight.y - this.topRight.y;
    }

    public Point getTopLeft() {
        return this.topLeft;
    }

    public Point getTopRight() {
        return this.topRight;
    }

    public int getWidth() {
        return this.topRight.x - this.topLeft.x;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.bottomLeft, this.bottomRight, this.topLeft, this.topRight});
    }

    @Override
    public Iterator<Point> iterator() {
        return Arrays.asList(this.topLeft, this.topRight, this.bottomLeft, this.bottomRight).iterator();
    }

    public Locations moveAllBy(int x, int y) {
        return new Locations(this.topLeft.moveBy(x, y), this.topRight.moveBy(x, y), this.bottomLeft.moveBy(x, y), this.bottomRight.moveBy(x, y));
    }

    public Locations resizeFromBottomRight(int byXPixels, int byYPixels) {
        return new Locations(this.topLeft, this.topRight.moveBy(byXPixels, 0), this.bottomLeft.moveBy(0, byYPixels), this.bottomRight.moveBy(byXPixels, byYPixels));
    }

    public String toString() {
        return "Locations{topLeft=" + this.topLeft + ", topRight=" + this.topRight + ", bottomLeft=" + this.bottomLeft + ", bottomRight=" + this.bottomRight + '}';
    }
}

