/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.panelMenu;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.condition.element.WebElementConditionFactory;
import org.jboss.arquillian.graphene.wait.FluentWait;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.ErrorHandler;
import org.richfaces.fragment.common.AdvancedVisibleComponentIteractions;
import org.richfaces.fragment.common.Event;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.common.VisibleComponentInteractions;
import org.richfaces.fragment.common.WaitingWrapper;
import org.richfaces.fragment.common.WaitingWrapperImpl;
import org.richfaces.fragment.common.picker.ChoicePicker;
import org.richfaces.fragment.common.picker.ChoicePickerHelper;
import org.richfaces.fragment.panelMenu.PanelMenu;
import org.richfaces.fragment.panelMenu.PanelMenuGroup;
import org.richfaces.fragment.panelMenu.PanelMenuItem;
import org.richfaces.fragment.panelMenu.RichFacesPanelMenuGroup;
import org.richfaces.fragment.panelMenu.RichFacesPanelMenuItem;

public abstract class AbstractPanelMenu
implements PanelMenu,
PanelMenuGroup,
AdvancedVisibleComponentIteractions<AdvancedAbstractPanelMenuInteractions> {
    @ArquillianResource
    private JavascriptExecutor executor;
    @Drone
    private WebDriver browser;

    @Override
    public PanelMenuItem selectItem(ChoicePicker picker) {
        WebElement itemRoot = picker.pick(this.getMenuItems());
        this.ensureElementExist(itemRoot);
        this.ensureElementIsEnabledAndVisible(itemRoot);
        RichFacesPanelMenuItem panelMenuItem = (RichFacesPanelMenuItem)Graphene.createPageFragment(RichFacesPanelMenuItem.class, (WebElement)itemRoot);
        panelMenuItem.select();
        return panelMenuItem;
    }

    @Override
    public PanelMenuItem selectItem(String header) {
        return this.selectItem(ChoicePickerHelper.byVisibleText().match(header));
    }

    @Override
    public PanelMenuItem selectItem(int index) {
        return this.selectItem(ChoicePickerHelper.byIndex().index(index));
    }

    @Override
    public PanelMenuGroup expandGroup(ChoicePicker picker) {
        WebElement groupRoot = picker.pick(this.getMenuGroups());
        this.ensureElementExist(groupRoot);
        this.ensureElementIsEnabledAndVisible(groupRoot);
        WebElement groupHeader = this.getHeaderElementDynamically(groupRoot);
        if (this.isGroupExpanded(groupHeader)) {
            return (PanelMenuGroup)Graphene.createPageFragment(RichFacesPanelMenuGroup.class, (WebElement)groupRoot);
        }
        this.executeEventOn(this.advanced().getExpandEvent(), groupHeader);
        this.advanced().waitUntilMenuGroupExpanded(groupHeader).perform();
        return (PanelMenuGroup)Graphene.createPageFragment(RichFacesPanelMenuGroup.class, (WebElement)groupRoot);
    }

    @Override
    public PanelMenuGroup expandGroup(String header) {
        return this.expandGroup(ChoicePickerHelper.byVisibleText().startsWith(header));
    }

    @Override
    public PanelMenuGroup expandGroup(int index) {
        return this.expandGroup(ChoicePickerHelper.byIndex().index(index));
    }

    @Override
    public void collapseGroup(ChoicePicker picker) {
        WebElement groupRoot = picker.pick(this.getMenuGroups());
        this.ensureElementExist(groupRoot);
        this.ensureElementIsEnabledAndVisible(groupRoot);
        WebElement groupHeader = this.getHeaderElementDynamically(groupRoot);
        if (!this.isGroupExpanded(groupHeader)) {
            return;
        }
        this.executeEventOn(this.advanced().getCollapseEvent(), groupHeader);
        this.advanced().waitUntilMenuGroupCollapsed(groupHeader).perform();
    }

    @Override
    public void collapseGroup(String header) {
        this.collapseGroup(ChoicePickerHelper.byVisibleText().startsWith(header));
    }

    @Override
    public void collapseGroup(int index) {
        this.collapseGroup(ChoicePickerHelper.byIndex().index(index));
    }

    @Override
    public PanelMenu expandAll() {
        throw new UnsupportedOperationException();
    }

    @Override
    public PanelMenu collapseAll() {
        throw new UnsupportedOperationException();
    }

    public abstract List<WebElement> getMenuItems();

    public abstract List<WebElement> getMenuGroups();

    @Override
    public abstract AdvancedAbstractPanelMenuInteractions advanced();

    private boolean isGroupExpanded(WebElement groupHeader) {
        return groupHeader.getAttribute("class").contains(this.advanced().getCssExpandedSuffix());
    }

    private void ensureElementIsEnabledAndVisible(WebElement element) {
        this.checkElementIsVisible(element);
        if (this.isDisabled(element)) {
            throw new IllegalArgumentException("Element " + element + " can not be interacted with, as it is disabled.");
        }
    }

    private boolean isDisabled(WebElement group) {
        return group.getAttribute("class").contains(this.advanced().getCssDisabledSuffix());
    }

    private void checkElementIsVisible(WebElement element) {
        if (!((Boolean)new WebElementConditionFactory(element).isVisible().apply((Object)this.browser)).booleanValue()) {
            throw new IllegalArgumentException("Element: " + element + " must be visible before interacting with it!");
        }
    }

    private void executeEventOn(Event event, WebElement element) {
        Utils.triggerJQ(this.executor, event.getEventName(), element);
    }

    private WebElement getHeaderElementDynamically(WebElement element) {
        return element.findElement(By.cssSelector((String)this.advanced().getHeaderSelectorToInovkeEventOn()));
    }

    private void ensureElementExist(WebElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Group/item must exist!");
        }
    }

    public abstract class AdvancedAbstractPanelMenuInteractions
    implements VisibleComponentInteractions {
        private static final String CSS_EXPANDED_SUFFIX = "-exp";
        private static final String CSS_TRANSPARENT_SUFFIX = "-transparent";
        private static final String CSS_SELECTED_SUFFIX = "-sel";
        private static final String CSS_HOVERED_SUFFIX = "-hov";
        private static final String CSS_DISABLED_SUFFIX = "-dis";
        private static final String CSS_COLLAPSED_SUFFIX = "-colps";
        private static final String HEADER_SELECTOR_TO_INVOKE_EVENT_ON = "div[class*=rf-pm-][class*=-gr-hdr]";
        private Event expandEvent = Event.CLICK;
        private Event collapseEvent = Event.CLICK;
        private long _timoutForMenuGroupToBeExpanded = -1L;
        private long _timeoutForMenuGroupToBeCollapsed = -1L;

        protected String getHeaderSelectorToInovkeEventOn() {
            return HEADER_SELECTOR_TO_INVOKE_EVENT_ON;
        }

        protected String getCssExpandedSuffix() {
            return CSS_EXPANDED_SUFFIX;
        }

        protected String getCssTransparentSuffix() {
            return CSS_TRANSPARENT_SUFFIX;
        }

        protected String getCssSelectedSuffix() {
            return CSS_SELECTED_SUFFIX;
        }

        protected String getCssHoveredSuffix() {
            return CSS_HOVERED_SUFFIX;
        }

        protected String getCssDisabledSuffix() {
            return CSS_DISABLED_SUFFIX;
        }

        protected String getCssCollapsedSuffix() {
            return CSS_COLLAPSED_SUFFIX;
        }

        protected Event getExpandEvent() {
            return this.expandEvent;
        }

        protected Event getCollapseEvent() {
            return this.collapseEvent;
        }

        public void setExpandEvent(Event event) {
            this.expandEvent = event;
        }

        public void setCollapseEvent(Event event) {
            this.collapseEvent = event;
        }

        public boolean isGroupExpanded(WebElement groupRoot) {
            return AbstractPanelMenu.this.isGroupExpanded(AbstractPanelMenu.this.getHeaderElementDynamically(groupRoot));
        }

        public WaitingWrapper waitUntilMenuGroupExpanded(final WebElement groupHeader) {
            return new WaitingWrapperImpl(){

                @Override
                protected void performWait(FluentWait<WebDriver, Void> wait) {
                    wait.ignoring(ErrorHandler.UnknownServerException.class).until((Predicate)new Predicate<WebDriver>(){

                        public boolean apply(WebDriver input) {
                            return AbstractPanelMenu.this.isGroupExpanded(groupHeader);
                        }
                    });
                }
            }.withMessage("Waiting for Panel Menu group to be expanded!").withTimeout(this.getTimoutForMenuGroupToBeExpanded(), TimeUnit.MILLISECONDS);
        }

        public WaitingWrapper waitUntilMenuGroupCollapsed(final WebElement groupHeader) {
            return new WaitingWrapperImpl(){

                @Override
                protected void performWait(FluentWait<WebDriver, Void> wait) {
                    wait.ignoring(ErrorHandler.UnknownServerException.class).until((Predicate)new Predicate<WebDriver>(){

                        public boolean apply(WebDriver input) {
                            return !AbstractPanelMenu.this.isGroupExpanded(groupHeader);
                        }
                    });
                }
            }.withMessage("Waiting for Panel Menu group to be expanded!").withTimeout(this.getTimeoutForMenuGroupToBeCollapsed(), TimeUnit.MILLISECONDS);
        }

        public void setTimoutForMenuGroupToBeExpanded(long timeoutInMilliseconds) {
            this._timoutForMenuGroupToBeExpanded = timeoutInMilliseconds;
        }

        public long getTimoutForMenuGroupToBeExpanded() {
            return this._timoutForMenuGroupToBeExpanded == -1L ? Utils.getWaitAjaxDefaultTimeout(AbstractPanelMenu.this.browser) : this._timoutForMenuGroupToBeExpanded;
        }

        public void setTimeoutForMenuGroupToBeCollapsed(long timeoutInMilliseconds) {
            this._timeoutForMenuGroupToBeCollapsed = timeoutInMilliseconds;
        }

        public long getTimeoutForMenuGroupToBeCollapsed() {
            return this._timeoutForMenuGroupToBeCollapsed == -1L ? Utils.getWaitAjaxDefaultTimeout(AbstractPanelMenu.this.browser) : this._timeoutForMenuGroupToBeCollapsed;
        }

        protected abstract WebElement getRootElement();

        @Override
        public boolean isVisible() {
            return Utils.isVisible(this.getRootElement());
        }
    }
}

