/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.inputNumberSlider;

import org.jboss.arquillian.graphene.condition.element.WebElementConditionFactory;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.richfaces.fragment.common.ClearType;
import org.richfaces.fragment.common.TextInputComponentImpl;
import org.richfaces.fragment.inputNumberSlider.NumberInput;

public abstract class AbstractNumberInput
implements NumberInput {
    @ArquillianResource
    private WebDriver browser;

    public abstract AdvancedNumberInputInteractions advanced();

    @Override
    public void increase() {
        if (!((Boolean)new WebElementConditionFactory(this.advanced().getArrowIncreaseElement()).isVisible().apply((Object)this.browser)).booleanValue()) {
            throw new RuntimeException("Arrow for increasing value is not visible.");
        }
        this.advanced().getArrowIncreaseElement().click();
    }

    @Override
    public void decrease() {
        if (!((Boolean)new WebElementConditionFactory(this.advanced().getArrowDecreaseElement()).isVisible().apply((Object)this.browser)).booleanValue()) {
            throw new RuntimeException("arrow for decreasing value is not visible.");
        }
        this.advanced().getArrowDecreaseElement().click();
    }

    @Override
    public void increase(int n) {
        for (int i = 0; i < n; ++i) {
            this.increase();
        }
    }

    @Override
    public void decrease(int n) {
        for (int i = 0; i < n; ++i) {
            this.decrease();
        }
    }

    @Override
    public void setValue(double value) {
        this.advanced().getInput().advanced().clear(ClearType.BACKSPACE).sendKeys(String.valueOf(value));
    }

    @Override
    public double getValue() {
        return Double.valueOf(this.advanced().getInput().getStringValue());
    }

    public abstract class AdvancedNumberInputInteractions {
        public abstract WebElement getArrowIncreaseElement();

        public abstract WebElement getArrowDecreaseElement();

        public abstract TextInputComponentImpl getInput();
    }
}

