/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.autocomplete;

import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.fragment.Root;
import org.jboss.arquillian.graphene.wait.FluentWait;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.richfaces.fragment.autocomplete.Autocomplete;
import org.richfaces.fragment.autocomplete.SelectOrConfirm;
import org.richfaces.fragment.common.Actions;
import org.richfaces.fragment.common.AdvancedVisibleComponentIteractions;
import org.richfaces.fragment.common.ClearType;
import org.richfaces.fragment.common.ScrollingType;
import org.richfaces.fragment.common.TextInputComponentImpl;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.common.VisibleComponentInteractions;
import org.richfaces.fragment.common.WaitingWrapper;
import org.richfaces.fragment.common.WaitingWrapperImpl;
import org.richfaces.fragment.common.picker.ChoicePicker;
import org.richfaces.fragment.common.picker.ChoicePickerHelper;

public class RichFacesAutocomplete
implements Autocomplete,
AdvancedVisibleComponentIteractions<AdvancedAutocompleteInteractions> {
    @Drone
    private WebDriver driver;
    @Root
    private WebElement root;
    @FindBy(css="input[type='text']")
    private TextInputComponentImpl input;
    private final AdvancedAutocompleteInteractions advancedInteractions = new AdvancedAutocompleteInteractions();

    @Override
    public AdvancedAutocompleteInteractions advanced() {
        return this.advancedInteractions;
    }

    @Override
    public void clear() {
        this.advanced().clear(ClearType.DEFAULT_CLEAR_TYPE);
    }

    @Override
    public SelectOrConfirm type(String str) {
        if (!this.advanced().getInput().getStringValue().isEmpty()) {
            this.advanced().getInput().sendKeys(this.advanced().getToken() + " ");
        }
        this.advanced().getInput().sendKeys(str);
        return new SelectOrConfirmImpl();
    }

    public class SelectOrConfirmImpl
    implements SelectOrConfirm {
        @Override
        public Autocomplete confirm() {
            boolean selectFirst = RichFacesAutocomplete.this.advanced().isSelectFirst();
            if (selectFirst && !RichFacesAutocomplete.this.advanced().getSuggestionsElements().isEmpty()) {
                this.select();
            } else {
                new Actions(RichFacesAutocomplete.this.driver).click(RichFacesAutocomplete.this.driver.findElement(Utils.BY_BODY)).perform();
                Graphene.waitModel().until().element(RichFacesAutocomplete.this.advanced().getInput().advanced().getInputElement()).is().present();
                RichFacesAutocomplete.this.advanced().getInput().advanced().getInputElement().click();
            }
            return RichFacesAutocomplete.this;
        }

        @Override
        public Autocomplete select() {
            return this.select(ChoicePickerHelper.byIndex().first());
        }

        @Override
        public Autocomplete select(ChoicePicker picker) {
            RichFacesAutocomplete.this.advanced().waitForSuggestionsToBeVisible().perform();
            WebElement foundValue = picker.pick(RichFacesAutocomplete.this.advanced().getSuggestionsElements());
            if (foundValue == null) {
                throw new RuntimeException("The value was not found by " + picker.toString());
            }
            if (RichFacesAutocomplete.this.advanced().getScrollingType() == ScrollingType.BY_KEYS) {
                this.selectWithKeys(foundValue);
            } else {
                new Actions(RichFacesAutocomplete.this.driver).moveToElement(foundValue).click(foundValue).perform();
            }
            RichFacesAutocomplete.this.advanced().waitForSuggestionsToBeNotVisible().perform();
            return RichFacesAutocomplete.this;
        }

        @Override
        public Autocomplete select(int index) {
            return this.select(ChoicePickerHelper.byIndex().index(index));
        }

        @Override
        public Autocomplete select(String match) {
            return this.select(ChoicePickerHelper.byVisibleText().match(match));
        }

        protected void selectWithKeys(WebElement foundValue) {
            int steps = Utils.getIndexOfElement(foundValue) + (RichFacesAutocomplete.this.advanced().isSelectFirst() ? 0 : 1);
            Actions actions = new Actions(RichFacesAutocomplete.this.driver);
            for (int i = 0; i < steps; ++i) {
                actions.sendKeys(new CharSequence[]{Keys.ARROW_DOWN});
            }
            actions.sendKeys(foundValue, new CharSequence[]{Keys.TAB}).perform();
        }
    }

    public class AdvancedAutocompleteInteractions
    implements VisibleComponentInteractions {
        private static final String SUGGESTIONS_CSS_SELECTOR_TEMPLATE = ".rf-au-lst-cord[id='%sList'] .rf-au-itm";
        private static final String DEFAULT_TOKEN = ",";
        private static final String SELECT_FIRST_ATT_NAME = "selectFirst";
        private final ScrollingType DEFAULT_SCROLLING_TYPE;
        private ScrollingType scrollingType;
        private String token;
        private long _timeoutForSuggestionsToBeNotVisible;
        private long _timeoutForSuggestionsToBeVisible;

        public AdvancedAutocompleteInteractions() {
            this.scrollingType = this.DEFAULT_SCROLLING_TYPE = ScrollingType.BY_MOUSE;
            this.token = DEFAULT_TOKEN;
            this._timeoutForSuggestionsToBeNotVisible = -1L;
            this._timeoutForSuggestionsToBeVisible = -1L;
        }

        public TextInputComponentImpl clear(ClearType clearType) {
            return RichFacesAutocomplete.this.advanced().getInput().advanced().clear(clearType);
        }

        public TextInputComponentImpl getInput() {
            return RichFacesAutocomplete.this.input;
        }

        public WebElement getRootElement() {
            return RichFacesAutocomplete.this.root;
        }

        protected ScrollingType getScrollingType() {
            return this.scrollingType;
        }

        protected String getSuggestionsSelectorTemplate() {
            return SUGGESTIONS_CSS_SELECTOR_TEMPLATE;
        }

        public List<WebElement> getSuggestionsElements() {
            String id = this.getRootElement().getAttribute("id");
            String selectorOfRoot = String.format(this.getSuggestionsSelectorTemplate(), id);
            List foundElements = RichFacesAutocomplete.this.driver.findElements(By.cssSelector((String)selectorOfRoot));
            if (!foundElements.isEmpty() && ((WebElement)foundElements.get(0)).isDisplayed()) {
                return Collections.unmodifiableList(foundElements);
            }
            return Collections.emptyList();
        }

        public String getToken() {
            return this.token;
        }

        public void setToken() {
            this.token = DEFAULT_TOKEN;
        }

        public void setToken(String value) {
            this.token = value;
        }

        public void setScrollingType() {
            this.scrollingType = this.DEFAULT_SCROLLING_TYPE;
        }

        public void setScrollingType(ScrollingType type) {
            this.scrollingType = type;
        }

        public WaitingWrapper waitForSuggestionsToBeNotVisible() {
            return new WaitingWrapperImpl(){

                @Override
                protected void performWait(FluentWait<WebDriver, Void> wait) {
                    wait.until((Predicate)new Predicate<WebDriver>(){

                        public boolean apply(WebDriver input) {
                            return AdvancedAutocompleteInteractions.this.getSuggestionsElements().isEmpty();
                        }
                    });
                }
            }.withMessage("Waiting for suggestions to be not visible").withTimeout(this.getTimeoutForSuggestionsToBeNotVisible(), TimeUnit.MILLISECONDS);
        }

        public WaitingWrapper waitForSuggestionsToBeVisible() {
            return new WaitingWrapperImpl(){

                @Override
                protected void performWait(FluentWait<WebDriver, Void> wait) {
                    wait.until((Predicate)new Predicate<WebDriver>(){

                        public boolean apply(WebDriver input) {
                            return !AdvancedAutocompleteInteractions.this.getSuggestionsElements().isEmpty();
                        }
                    });
                }
            }.withMessage("Waiting for suggestions to be visible").withTimeout(this.getTimeoutForSuggestionsToBeVisible(), TimeUnit.MILLISECONDS);
        }

        public void setTimeoutForSuggestionsToBeNotVisible(long timeoutInMilliseconds) {
            this._timeoutForSuggestionsToBeNotVisible = timeoutInMilliseconds;
        }

        public void setTimeoutForSuggestionsToBeVisible(long timeoutInMilliseconds) {
            this._timeoutForSuggestionsToBeVisible = timeoutInMilliseconds;
        }

        public long getTimeoutForSuggestionsToBeNotVisible() {
            return this._timeoutForSuggestionsToBeNotVisible == -1L ? Utils.getWaitAjaxDefaultTimeout(RichFacesAutocomplete.this.driver) : this._timeoutForSuggestionsToBeNotVisible;
        }

        public long getTimeoutForSuggestionsToBeVisible() {
            return this._timeoutForSuggestionsToBeVisible == -1L ? Utils.getWaitAjaxDefaultTimeout(RichFacesAutocomplete.this.driver) : this._timeoutForSuggestionsToBeVisible;
        }

        protected boolean isSelectFirst() {
            return (Boolean)Utils.getComponentOption(this.getRootElement(), SELECT_FIRST_ATT_NAME).or((Object)Boolean.TRUE);
        }

        @Override
        public boolean isVisible() {
            return Utils.isVisible(this.getRootElement());
        }
    }
}

