/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.util;

import java.util.Iterator;
import java.util.Map;
import junit.framework.TestCase;
import org.richfaces.util.LRUMap;

public class LRUMapTest
extends TestCase {
    public LRUMapTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testLRUMap() {
        LRUMap map = new LRUMap(5);
        for (int i = 0; i < 10; ++i) {
            map.put((Object)new Integer(i), (Object)("Val" + new Integer(i)));
        }
        LRUMapTest.assertEquals((int)map.size(), (int)5);
    }

    public void testRemoveEldestEntryEntry() {
        LRUMap map = new LRUMap(5){

            protected boolean removeEldestEntry(Map.Entry arg0) {
                boolean eldestEntry = super.removeEldestEntry(arg0);
                TestCase.assertTrue((boolean)(eldestEntry ^ this.size() <= 5));
                return false;
            }
        };
        for (int i = 0; i < 10; ++i) {
            map.put((Object)new Integer(i), (Object)("Val" + new Integer(i)));
        }
    }

    public void testPut() {
        LRUMap map = new LRUMap(5);
        for (int i = 0; i < 10; ++i) {
            map.put((Object)new Integer(i), (Object)("Val" + new Integer(i)));
        }
        LRUMapTest.assertEquals((int)map.size(), (int)5);
        Iterator iterator = map.values().iterator();
        for (int i = 5; i < 10; ++i) {
            LRUMapTest.assertTrue((boolean)iterator.hasNext());
            LRUMapTest.assertEquals((Object)("Val" + new Integer(i)), iterator.next());
        }
        LRUMapTest.assertFalse((boolean)iterator.hasNext());
    }
}

