/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.mapping;

import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import org.jboss.test.faces.mockito.runner.FacesMockitoRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.richfaces.application.CoreConfiguration;
import org.richfaces.application.ServiceTracker;
import org.richfaces.resource.mapping.AbstractResourceMappingTest;
import org.richfaces.resource.mapping.ResourceMappingConfiguration;

@RunWith(value=FacesMockitoRunner.class)
public class ResourceMappingFeatureLocationTest
extends AbstractResourceMappingTest {
    @Test
    public void shouldThrowExceptionWhenResourceLoadingOptimizationDisabled() {
        this.configure((Enum<?>)CoreConfiguration.Items.resourceOptimizationEnabled, false);
        this.testLocation(null, "#{facesContext.externalContext.requestContextPath}/org.richfaces.resources/javax.faces.resource/");
    }

    @Test
    public void testDefaultLocationWhenResourceLoadingOptimizationEnabled() {
        this.configure((Enum<?>)CoreConfiguration.Items.resourceOptimizationEnabled, true);
        this.testLocation(null, "#{facesContext.externalContext.requestContextPath}/org.richfaces.resources/javax.faces.resource/");
    }

    @Test
    public void testCustomLocationWhenResourceLoadingOptimizationDisabled() {
        this.configure((Enum<?>)CoreConfiguration.Items.resourceOptimizationEnabled, false);
        this.testLocation("some_expression", "some_expression");
    }

    @Test
    public void testCustomLocationWhenResourceLoadingOptimizationEnabled() {
        this.configure((Enum<?>)CoreConfiguration.Items.resourceOptimizationEnabled, true);
        this.testLocation("some_expression", "some_expression");
    }

    private void testLocation(String configuredValue, String expectedResolvedLocationExpression) {
        String expectedResolvedLocation = "evaluated_location";
        ExpressionFactory expressionFactory = (ExpressionFactory)Mockito.mock(ExpressionFactory.class);
        ValueExpression valueExpression = (ValueExpression)Mockito.mock(ValueExpression.class);
        this.configure((Enum<?>)CoreConfiguration.Items.resourceMappingLocation, expectedResolvedLocationExpression);
        Mockito.when((Object)this.application.getExpressionFactory()).thenReturn((Object)expressionFactory);
        Mockito.when((Object)expressionFactory.createValueExpression(this.elContext, expectedResolvedLocationExpression, Object.class)).thenReturn((Object)valueExpression);
        Mockito.when((Object)valueExpression.getValue(this.elContext)).thenReturn((Object)expectedResolvedLocation);
        String location = ((ResourceMappingConfiguration)ServiceTracker.getService(ResourceMappingConfiguration.class)).getLocation();
        Assert.assertEquals((Object)expectedResolvedLocation, (Object)location);
    }
}

