/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.context.FacesContext;
import org.jboss.test.faces.FacesEnvironment;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.richfaces.resource.AbstractJava2DUserResource;
import org.richfaces.resource.AbstractUserResource;
import org.richfaces.resource.CacheableResource;
import org.richfaces.resource.DynamicUserResource;
import org.richfaces.resource.VersionedResource;

public class UserResourcesTestCase {
    private static final String PACKAGE_VERSION = "test-package-1.0";
    private static final String CACHEABLE_OVERRIDE_KEY = "org.richfaces.test.CacheableOverrideKey";
    private static final String VERSION_OVERRIDE_KEY = "org.richfaces.test.VersionOverrideKey";
    private FacesEnvironment environment;
    private FacesEnvironment.FacesRequest facesRequest;
    private ResourceHandler resourceHandler;

    @Before
    public void setUp() throws Exception {
        this.environment = FacesEnvironment.createEnvironment();
        this.environment.getServer().addInitParameter("org.richfaces.resourceDefaultVersion", PACKAGE_VERSION);
        this.environment.start();
        this.facesRequest = this.environment.createFacesRequest();
        this.facesRequest.start();
        this.resourceHandler = FacesContext.getCurrentInstance().getApplication().getResourceHandler();
    }

    @After
    public void tearDown() throws Exception {
        this.resourceHandler = null;
        this.facesRequest.release();
        this.facesRequest = null;
        this.environment.release();
        this.environment = null;
    }

    private void checkResource(Resource resource, boolean cacheable, String version) {
        Assert.assertTrue((boolean)(resource instanceof VersionedResource));
        Assert.assertEquals((Object)version, (Object)((VersionedResource)resource).getVersion());
        Assert.assertTrue((boolean)(resource instanceof CacheableResource));
        Assert.assertEquals((Object)cacheable, (Object)((CacheableResource)resource).isCacheable(FacesContext.getCurrentInstance()));
    }

    @Test
    @Ignore
    public void testResources() throws Exception {
        this.checkResource(this.resourceHandler.createResource(DefaultSettingsUserResource.class.getName()), true, PACKAGE_VERSION);
        this.checkResource(this.resourceHandler.createResource(NonCacheableUserResource.class.getName()), false, PACKAGE_VERSION);
        this.checkResource(this.resourceHandler.createResource(NonVersionedUserResource.class.getName()), true, null);
    }

    @Test
    @Ignore
    public void testJava2DResources() throws Exception {
        this.checkResource(this.resourceHandler.createResource(DefaultSettingsJava2DUserResource.class.getName()), true, PACKAGE_VERSION);
        this.checkResource(this.resourceHandler.createResource(NonCacheableJava2DUserResource.class.getName()), false, PACKAGE_VERSION);
        this.checkResource(this.resourceHandler.createResource(NonVersionedJava2DUserResource.class.getName()), true, null);
    }

    @Test
    public void testSettingsOverridableResource() throws Exception {
        Map attributes = FacesContext.getCurrentInstance().getAttributes();
        attributes.put(CACHEABLE_OVERRIDE_KEY, true);
        attributes.put(VERSION_OVERRIDE_KEY, "some.version");
        this.checkResource(this.resourceHandler.createResource(SettingsOverridableResource.class.getName()), true, "some.version");
        attributes.put(CACHEABLE_OVERRIDE_KEY, false);
        attributes.put(VERSION_OVERRIDE_KEY, null);
        this.checkResource(this.resourceHandler.createResource(SettingsOverridableResource.class.getName()), false, null);
    }

    @DynamicUserResource
    public static final class SettingsOverridableResource
    extends BaseUserResource
    implements VersionedResource,
    CacheableResource {
        public boolean isCacheable(FacesContext context) {
            return Boolean.TRUE.equals(context.getAttributes().get(UserResourcesTestCase.CACHEABLE_OVERRIDE_KEY));
        }

        public Date getExpires(FacesContext context) {
            return null;
        }

        public int getTimeToLive(FacesContext context) {
            return 0;
        }

        public String getEntityTag(FacesContext context) {
            return null;
        }

        public String getVersion() {
            return (String)FacesContext.getCurrentInstance().getAttributes().get(UserResourcesTestCase.VERSION_OVERRIDE_KEY);
        }
    }

    @DynamicUserResource
    public static final class DefaultSettingsJava2DUserResource
    extends BaseJava2DUserResource {
    }

    @DynamicUserResource
    public static final class DefaultSettingsUserResource
    extends BaseUserResource {
    }

    @DynamicUserResource(cacheable=false)
    public static final class NonCacheableJava2DUserResource
    extends BaseJava2DUserResource {
    }

    @DynamicUserResource(cacheable=false)
    public static final class NonCacheableUserResource
    extends BaseUserResource {
    }

    @DynamicUserResource(versioned=false)
    public static final class NonVersionedJava2DUserResource
    extends BaseJava2DUserResource {
    }

    @DynamicUserResource(versioned=false)
    public static final class NonVersionedUserResource
    extends BaseUserResource {
    }

    protected static class BaseJava2DUserResource
    extends AbstractJava2DUserResource {
        public BaseJava2DUserResource() {
            super(new Dimension(10, 5));
        }

        public void paint(Graphics2D graphics2d) {
        }
    }

    protected static class BaseUserResource
    extends AbstractUserResource {
        protected BaseUserResource() {
        }

        public void encode(FacesContext facesContext) throws IOException {
            facesContext.getResponseWriter().write(((Object)((Object)this)).getClass().getSimpleName());
        }

        public String getContentType() {
            return "text/plain";
        }
    }
}

